"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateFilterKueryNode = exports.isFieldDefined = exports.hasFieldKeyError = exports.allowedFleetActionsResultsFields = exports.allowedFleetActionsFields = exports.ALLOWED_FLEET_ACTIONS_RESULTS_FIELD_TYPES = exports.ALLOWED_FLEET_ACTIONS_FIELD_TYPES = void 0;
var _lodash = require("lodash");
var _std = require("@kbn/std");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldType = (key, indexMappings) => {
  const mappingKey = `properties.${key}.type`;
  return key != null ? (0, _lodash.get)(indexMappings, mappingKey) : '';
};
const isFieldDefined = (indexMappings, key) => {
  const mappingKey = 'properties.' + key;
  return typeof (0, _lodash.get)(indexMappings, mappingKey) !== 'undefined';
};
exports.isFieldDefined = isFieldDefined;
const hasFieldKeyError = (key, fieldTypes, indexMapping, indexType) => {
  const allowedKeys = Object.keys(indexMapping.properties).join();
  if (key == null) {
    return `The key is empty and should be one of [${allowedKeys}]`;
  }
  if (key) {
    const allowedFieldTypes = fieldTypes.every(type => indexType === 'actions' ? ALLOWED_FLEET_ACTIONS_FIELD_TYPES.includes(type) : ALLOWED_FLEET_ACTIONS_RESULTS_FIELD_TYPES.includes(type));
    const indexName = indexType === 'actions' ? _common.AGENT_ACTIONS_INDEX : _common.AGENT_ACTIONS_RESULTS_INDEX;
    if (!isFieldDefined(indexMapping, key)) {
      return `This key '${key}' does not exist in ${indexName} index mappings`;
    }
    if (!allowedFieldTypes) {
      return `This key '${key}' does not match allowed field types in ${indexName} index mappings`;
    }
  }
  return null;
};
exports.hasFieldKeyError = hasFieldKeyError;
const ALLOWED_FLEET_ACTIONS_RESULTS_FIELD_TYPES = ['keyword'];
exports.ALLOWED_FLEET_ACTIONS_RESULTS_FIELD_TYPES = ALLOWED_FLEET_ACTIONS_RESULTS_FIELD_TYPES;
const ALLOWED_FLEET_ACTIONS_FIELD_TYPES = ['keyword', 'date'];
exports.ALLOWED_FLEET_ACTIONS_FIELD_TYPES = ALLOWED_FLEET_ACTIONS_FIELD_TYPES;
const allowedFleetActionsFields = (0, _std.deepFreeze)({
  properties: {
    action_id: {
      type: 'keyword'
    },
    agents: {
      type: 'keyword'
    },
    input_type: {
      type: 'keyword'
    },
    '@timestamp': {
      type: 'date'
    },
    type: {
      type: 'keyword'
    },
    user_id: {
      type: 'keyword'
    }
  }
});
exports.allowedFleetActionsFields = allowedFleetActionsFields;
const allowedFleetActionsResultsFields = (0, _std.deepFreeze)({
  properties: {
    action_id: {
      type: 'keyword'
    },
    agent_id: {
      type: 'keyword'
    }
  }
});
exports.allowedFleetActionsResultsFields = allowedFleetActionsResultsFields;
const validateFilterKueryNode = ({
  astFilter,
  types,
  indexMapping,
  indexType = 'actions',
  path = 'arguments'
}) => {
  return astFilter.arguments.reduce((kueryNode, ast, index) => {
    if (ast.arguments) {
      const myPath = `${path}.${index}`;
      return [...kueryNode, ...validateFilterKueryNode({
        astFilter: ast,
        types,
        indexMapping,
        path: `${myPath}.arguments`
      })];
    }
    if (index === 0) {
      const splitPath = path.split('.');
      return [...kueryNode, {
        astPath: splitPath.slice(0, splitPath.length - 1).join('.'),
        error: hasFieldKeyError(ast.value, types, indexMapping, indexType),
        key: ast.value,
        type: getFieldType(ast.value, indexMapping)
      }];
    }
    return kueryNode;
  }, []);
};
exports.validateFilterKueryNode = validateFilterKueryNode;