"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // Rotate fleet message signing key pair
  router.versioned.post({
    path: _constants2.MESSAGE_SIGNING_SERVICE_API_ROUTES.ROTATE_KEY_PAIR,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.RotateKeyPairSchema
    }
  }, _handlers.rotateKeyPairHandler);
};
exports.registerRoutes = registerRoutes;