"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.get({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.getDownloadSourcesRequestSchema
    }
  }, _handler.getDownloadSourcesHandler);
  router.versioned.get({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneDownloadSourcesRequestSchema
    }
  }, _handler.getOneDownloadSourcesHandler);
  router.versioned.put({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutDownloadSourcesRequestSchema
    }
  }, _handler.putDownloadSourcesHandler);
  router.versioned.post({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.CREATE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostDownloadSourcesRequestSchema
    }
  }, _handler.postDownloadSourcesHandler);
  router.versioned.delete({
    path: _constants2.DOWNLOAD_SOURCE_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteDownloadSourcesRequestSchema
    }
  }, _handler.deleteDownloadSourcesHandler);
};
exports.registerRoutes = registerRoutes;