"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentsPerOutput = getAgentsPerOutput;
var _lodash = _interopRequireDefault(require("lodash"));
var _common = require("../../common");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAgentsPerOutput(soClient, esClient) {
  var _outputs$find, _outputs$find2;
  const {
    items: outputs
  } = await _services.outputService.list(soClient);
  const defaultOutputId = ((_outputs$find = outputs.find(output => output.is_default)) === null || _outputs$find === void 0 ? void 0 : _outputs$find.id) || '';
  const defaultMonitoringOutputId = ((_outputs$find2 = outputs.find(output => output.is_default_monitoring)) === null || _outputs$find2 === void 0 ? void 0 : _outputs$find2.id) || '';
  const outputsById = _lodash.default.keyBy(outputs, 'id');
  const getOutputTypeById = outputId => {
    var _outputsById$outputId, _outputsById$outputId2;
    return (_outputsById$outputId = (_outputsById$outputId2 = outputsById[outputId]) === null || _outputsById$outputId2 === void 0 ? void 0 : _outputsById$outputId2.type) !== null && _outputsById$outputId !== void 0 ? _outputsById$outputId : '';
  };
  const {
    items
  } = await _services.agentPolicyService.list(soClient, {
    esClient,
    withAgentCount: true,
    page: 1,
    perPage: _common.SO_SEARCH_LIMIT
  });
  const outputTypes = {};
  items.filter(item => {
    var _item$agents;
    return ((_item$agents = item.agents) !== null && _item$agents !== void 0 ? _item$agents : 0) > 0;
  }).forEach(item => {
    var _item$agents2, _item$agents3;
    const dataOutputType = getOutputTypeById(item.data_output_id || defaultOutputId);
    if (!outputTypes[dataOutputType]) {
      outputTypes[dataOutputType] = {
        output_type: dataOutputType,
        count_as_data: 0,
        count_as_monitoring: 0
      };
    }
    outputTypes[dataOutputType].count_as_data += (_item$agents2 = item.agents) !== null && _item$agents2 !== void 0 ? _item$agents2 : 0;
    const monitoringOutputType = getOutputTypeById(item.monitoring_output_id || defaultMonitoringOutputId);
    if (!outputTypes[monitoringOutputType]) {
      outputTypes[monitoringOutputType] = {
        output_type: monitoringOutputType,
        count_as_data: 0,
        count_as_monitoring: 0
      };
    }
    outputTypes[monitoringOutputType].count_as_monitoring += (_item$agents3 = item.agents) !== null && _item$agents3 !== void 0 ? _item$agents3 : 0;
  });
  return Object.values(outputTypes);
}