"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentPoliciesUsage = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentPoliciesUsage = async soClient => {
  var _outputs$find;
  const {
    saved_objects: outputs
  } = await soClient.find({
    type: _common.OUTPUT_SAVED_OBJECT_TYPE,
    page: 1,
    perPage: _common.SO_SEARCH_LIMIT
  });
  const defaultOutputId = ((_outputs$find = outputs.find(output => output.attributes.is_default)) === null || _outputs$find === void 0 ? void 0 : _outputs$find.id) || '';
  const outputsById = _lodash.default.keyBy(outputs, 'id');
  const {
    saved_objects: agentPolicies,
    total: totalAgentPolicies
  } = await soClient.find({
    type: _common.AGENT_POLICY_SAVED_OBJECT_TYPE,
    page: 1,
    perPage: _common.SO_SEARCH_LIMIT
  });
  const uniqueOutputIds = new Set();
  agentPolicies.forEach(agentPolicy => {
    uniqueOutputIds.add(agentPolicy.attributes.monitoring_output_id || defaultOutputId);
    uniqueOutputIds.add(agentPolicy.attributes.data_output_id || defaultOutputId);
  });
  const uniqueOutputTypes = new Set(Array.from(uniqueOutputIds).map(outputId => {
    var _outputsById$outputId;
    return (_outputsById$outputId = outputsById[outputId]) === null || _outputsById$outputId === void 0 ? void 0 : _outputsById$outputId.attributes.type;
  }));
  return {
    count: totalAgentPolicies,
    output_types: Array.from(uniqueOutputTypes)
  };
};
exports.getAgentPoliciesUsage = getAgentPoliciesUsage;