"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIntegrationsTestRendererMock = exports.createFleetTestRendererMock = void 0;
var _history = require("history");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@testing-library/react");
var _reactHooks = require("@testing-library/react-hooks");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@tanstack/react-query");
var _mocks = require("@kbn/core/public/mocks");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/core/public");
var _experimental_features = require("../../common/experimental_features");
var _app = require("../applications/fleet/app");
var _app2 = require("../applications/integrations/app");
var _services = require("../services");
var _plugin_configuration = require("./plugin_configuration");
var _plugin_interfaces = require("./plugin_interfaces");
var _fleet_start_services = require("./fleet_start_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Test Renderer that includes mocked services and interfaces used during Fleet applicaiton rendering.
 * Any of the properties in this interface can be manipulated prior to `render()` if wanting to customize
 * the rendering context.
 */

const queryClient = new _reactQuery.QueryClient();
const createFleetTestRendererMock = () => {
  const basePath = '/mock';
  const extensions = {};
  const startServices = (0, _fleet_start_services.createStartServices)(basePath);
  const history = (0, _history.createMemoryHistory)({
    initialEntries: [basePath]
  });
  const mountHistory = new _public2.CoreScopedHistory(history, basePath);
  _services.ExperimentalFeaturesService.init(_experimental_features.allowedExperimentalValues);
  const HookWrapper = /*#__PURE__*/(0, _react.memo)(({
    children
  }) => {
    return /*#__PURE__*/_react.default.createElement(startServices.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: mountHistory
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...startServices
      }
    }, children))));
  });
  const testRendererMocks = {
    history,
    mountHistory,
    startServices,
    config: (0, _plugin_configuration.createConfigurationMock)(),
    startInterface: (0, _plugin_interfaces.createStartMock)(extensions),
    kibanaVersion: '8.0.0',
    setHeaderActionMenu: jest.fn(),
    AppWrapper: /*#__PURE__*/(0, _react.memo)(({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_app.FleetAppContext, {
        startServices: testRendererMocks.startServices,
        config: testRendererMocks.config,
        history: testRendererMocks.mountHistory,
        kibanaVersion: testRendererMocks.kibanaVersion,
        extensions: extensions,
        routerHistory: testRendererMocks.history,
        theme$: _mocks.themeServiceMock.createTheme$(),
        fleetStatus: {
          enabled: true,
          isLoading: false,
          isReady: true
        }
      }, children);
    }),
    HookWrapper,
    renderHook: callback => {
      return (0, _reactHooks.renderHook)(callback, {
        wrapper: testRendererMocks.HookWrapper
      });
    },
    render: (ui, options) => {
      let renderResponse;
      (0, _react2.act)(() => {
        renderResponse = (0, _react2.render)(ui, {
          wrapper: testRendererMocks.AppWrapper,
          ...options
        });
      });
      return renderResponse;
    }
  };
  return testRendererMocks;
};
exports.createFleetTestRendererMock = createFleetTestRendererMock;
const createIntegrationsTestRendererMock = () => {
  const basePath = '/mock';
  const extensions = {};
  const startServices = (0, _fleet_start_services.createStartServices)(basePath);
  const HookWrapper = /*#__PURE__*/(0, _react.memo)(({
    children
  }) => {
    return /*#__PURE__*/_react.default.createElement(startServices.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...startServices
      }
    }, children));
  });
  const testRendererMocks = {
    history: (0, _history.createMemoryHistory)(),
    mountHistory: new _public2.CoreScopedHistory((0, _history.createMemoryHistory)({
      initialEntries: [basePath]
    }), basePath),
    startServices,
    config: (0, _plugin_configuration.createConfigurationMock)(),
    startInterface: (0, _plugin_interfaces.createStartMock)(extensions),
    kibanaVersion: '8.0.0',
    setHeaderActionMenu: jest.fn(),
    AppWrapper: /*#__PURE__*/(0, _react.memo)(({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_app2.IntegrationsAppContext, {
        basepath: basePath,
        startServices: testRendererMocks.startServices,
        config: testRendererMocks.config,
        history: testRendererMocks.mountHistory,
        kibanaVersion: testRendererMocks.kibanaVersion,
        extensions: extensions,
        routerHistory: testRendererMocks.history,
        theme$: _mocks.themeServiceMock.createTheme$(),
        setHeaderActionMenu: () => {},
        fleetStatus: {
          enabled: true,
          isLoading: false,
          isReady: true
        }
      }, children);
    }),
    HookWrapper,
    render: (ui, options) => {
      let renderResponse;
      (0, _react2.act)(() => {
        renderResponse = (0, _react2.render)(ui, {
          wrapper: testRendererMocks.AppWrapper,
          ...options
        });
      });
      return renderResponse;
    },
    renderHook: callback => {
      return (0, _reactHooks.renderHook)(callback, {
        wrapper: testRendererMocks.HookWrapper
      });
    }
  };
  return testRendererMocks;
};
exports.createIntegrationsTestRendererMock = createIntegrationsTestRendererMock;