"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REDUCED_PLATFORM_OPTIONS = exports.PLATFORM_OPTIONS_CLOUD_SHELL = exports.PLATFORM_OPTIONS = void 0;
exports.usePlatform = usePlatform;
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REDUCED_PLATFORM_OPTIONS = [{
  id: 'linux',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux', {
    defaultMessage: 'Linux Tar'
  }),
  'data-test-subj': 'platformTypeLinux'
}, {
  id: 'mac',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.mac', {
    defaultMessage: 'Mac'
  }),
  'data-test-subj': 'platformTypeMac'
}, {
  id: 'windows',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.windows', {
    defaultMessage: 'Windows'
  }),
  'data-test-subj': 'platformTypeWindows'
}, {
  id: 'rpm',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux.rpm', {
    defaultMessage: 'RPM'
  }),
  'data-test-subj': 'platformTypeLinuxRpm'
}, {
  id: 'deb',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.linux.deb', {
    defaultMessage: 'DEB'
  }),
  'data-test-subj': 'platformTypeLinuxDeb'
}];
exports.REDUCED_PLATFORM_OPTIONS = REDUCED_PLATFORM_OPTIONS;
const PLATFORM_OPTIONS = [...REDUCED_PLATFORM_OPTIONS, {
  id: 'kubernetes',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.kubernetes', {
    defaultMessage: 'Kubernetes'
  }),
  'data-test-subj': 'platformTypeKubernetes'
}];
exports.PLATFORM_OPTIONS = PLATFORM_OPTIONS;
const PLATFORM_OPTIONS_CLOUD_SHELL = [...PLATFORM_OPTIONS, {
  id: 'googleCloudShell',
  label: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformButtons.googleCloudShell', {
    defaultMessage: 'Google Cloud Shell Script'
  }),
  'data-test-subj': 'platformTypeGoogleCloudShellScript'
}];
exports.PLATFORM_OPTIONS_CLOUD_SHELL = PLATFORM_OPTIONS_CLOUD_SHELL;
function usePlatform(initialPlatform = 'linux') {
  const [platform, setPlatform] = (0, _react.useState)(initialPlatform);
  return {
    platform,
    setPlatform
  };
}