"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardLocator = useDashboardLocator;
exports.useLocator = useLocator;
var _constants = require("../constants");
var _use_core = require("./use_core");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLocator(locatorId) {
  const services = (0, _use_core.useStartServices)();
  return services.share.url.locators.get(locatorId);
}
function useDashboardLocator() {
  return useLocator(_constants.LOCATORS_IDS.DASHBOARD_APP);
}