"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallCommandsPerPlatform = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateUninstallCommands = token => ({
  linuxOrMac: `sudo elastic-agent uninstall --uninstall-token ${token}`,
  windows: `C:\\"Program Files"\\Elastic\\Agent\\elastic-agent.exe uninstall --uninstall-token ${token}`
});
const PLATFORM_OPTIONS = [{
  id: 'linuxOrMac',
  label: _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.platformButtons.linuxOrMac', {
    defaultMessage: 'Linux or Mac'
  })
}, {
  id: 'windows',
  label: _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.platformButtons.windows', {
    defaultMessage: 'Windows'
  })
}];
const UninstallCommandsPerPlatform = ({
  token
}) => {
  const [platform, setPlatform] = (0, _react.useState)('linuxOrMac');
  const commands = (0, _react.useMemo)(() => generateUninstallCommands(token), [token]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: PLATFORM_OPTIONS,
    idSelected: platform,
    onChange: id => setPlatform(id),
    legend: _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.platformSelectAriaLabel', {
      defaultMessage: 'Platform'
    }),
    buttonSize: "m",
    "data-test-subj": "uninstall-commands-flyout-platforms-btn-group"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    paddingSize: "m",
    "data-test-subj": "uninstall-commands-flyout-code-block"
  }, commands[platform]));
};
exports.UninstallCommandsPerPlatform = UninstallCommandsPerPlatform;