"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallCommandFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _error = require("../error");
var _loading = require("../loading");
var _uninstall_tokens = require("../../hooks/use_request/uninstall_tokens");
var _uninstall_commands_per_platform = require("./uninstall_commands_per_platform");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UninstallAgentDescription = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.firstParagraph",
    defaultMessage: "Uninstall Elastic Agent and unenroll in Fleet to stop communicating with the host."
  })), /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.subtitle",
    defaultMessage: "Uninstall Elastic Agent on your host"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.description",
    defaultMessage: "Select the appropriate platform and run the command to uninstall Elastic Agent. Reuse the command to uninstall agents on more than one host. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.uninstallAgent,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.learnMore', {
        defaultMessage: 'Learn more'
      }))
    }
  })));
};
const UninstallEndpointDescription = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.endpointUninstallCommandFlyout.subtitle",
  defaultMessage: "Uninstall Elastic Defend integration on your host"
})), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.endpointUninstallCommandFlyout.description",
  defaultMessage: "Use the below uninstall command to uninstall Endpoint integration... [TODO]"
})));
const ErrorFetchingUninstallToken = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_error.Error, {
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.errorFetchingToken",
    defaultMessage: "Unable to fetch uninstall token"
  }),
  error: error !== null && error !== void 0 ? error : _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.unknownError', {
    defaultMessage: 'Unknown error'
  })
});
const UninstallCommandsByTokenId = ({
  uninstallTokenId
}) => {
  const {
    isLoading,
    error,
    data
  } = (0, _uninstall_tokens.useGetUninstallToken)(uninstallTokenId);
  const token = data === null || data === void 0 ? void 0 : data.item.token;
  const policyId = data === null || data === void 0 ? void 0 : data.item.policy_id;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, {
    size: "l"
  }) : error || !token ? /*#__PURE__*/_react.default.createElement(ErrorFetchingUninstallToken, {
    error: error
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_uninstall_commands_per_platform.UninstallCommandsPerPlatform, {
    token: token
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "uninstall-command-flyout-policy-id-hint"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.validForPolicyId",
    defaultMessage: "Valid for the following agent policy:"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, policyId)));
};
const UninstallCommandsByPolicyId = ({
  policyId
}) => {
  var _data$items, _data$items$;
  const {
    isLoading,
    error,
    data
  } = (0, _uninstall_tokens.useGetUninstallTokens)({
    policyId
  });
  const tokenId = data === null || data === void 0 ? void 0 : (_data$items = data.items) === null || _data$items === void 0 ? void 0 : (_data$items$ = _data$items[0]) === null || _data$items$ === void 0 ? void 0 : _data$items$.id;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, {
    size: "l"
  }) : error || !tokenId ? /*#__PURE__*/_react.default.createElement(ErrorFetchingUninstallToken, {
    error: error
  }) : /*#__PURE__*/_react.default.createElement(UninstallCommandsByTokenId, {
    uninstallTokenId: tokenId
  });
};
/** Flyout to show uninstall commands.
 *
 * Provide EITHER `policyId` OR `tokenId` for showing the token.
 */
const UninstallCommandFlyout = ({
  policyId,
  uninstallTokenId,
  onClose,
  target
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "uninstall-command-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.title",
    defaultMessage: "Uninstall agent"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, target === 'agent' ? /*#__PURE__*/_react.default.createElement(UninstallAgentDescription, null) : /*#__PURE__*/_react.default.createElement(UninstallEndpointDescription, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), uninstallTokenId ? /*#__PURE__*/_react.default.createElement(UninstallCommandsByTokenId, {
    uninstallTokenId: uninstallTokenId
  }) : policyId ? /*#__PURE__*/_react.default.createElement(UninstallCommandsByPolicyId, {
    policyId: policyId
  }) : null));
};
exports.UninstallCommandFlyout = UninstallCommandFlyout;