"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StandaloneSteps = exports.ManagedSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsYaml = require("js-yaml");
var _constants = require("../../../../common/constants");
var _services = require("../../../services");
var _enrollment_instructions = require("../../enrollment_instructions");
var _hooks = require("../../../hooks");
var _confirm_agent_enrollment = require("../confirm_agent_enrollment");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StandaloneSteps = ({
  agentPolicy,
  agentPolicies,
  selectedPolicy,
  setSelectedPolicyId,
  refreshAgentPolicies,
  mode,
  setMode,
  selectionType,
  selectedApiKeyId,
  setSelectedAPIKeyId,
  isK8s,
  cloudSecurityIntegration
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    notifications
  } = core;
  const [fullAgentPolicy, setFullAgentPolicy] = (0, _react.useState)();
  const [yaml, setYaml] = (0, _react.useState)('');
  let downloadLink = '';
  if (selectedPolicy !== null && selectedPolicy !== void 0 && selectedPolicy.id) {
    downloadLink = isK8s === 'IS_KUBERNETES' ? core.http.basePath.prepend(`${_services.agentPolicyRouteService.getInfoFullDownloadPath(selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id)}?kubernetes=true&standalone=true&apiVersion=${_constants.API_VERSIONS.public.v1}`) : core.http.basePath.prepend(`${_services.agentPolicyRouteService.getInfoFullDownloadPath(selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id)}?standalone=true&apiVersion=${_constants.API_VERSIONS.public.v1}`);
  }
  (0, _react.useEffect)(() => {
    async function fetchFullPolicy() {
      try {
        if (!(selectedPolicy !== null && selectedPolicy !== void 0 && selectedPolicy.id)) {
          return;
        }
        let query = {
          standalone: true,
          kubernetes: false
        };
        if (isK8s === 'IS_KUBERNETES') {
          query = {
            standalone: true,
            kubernetes: true
          };
        }
        const res = await (0, _hooks.sendGetOneAgentPolicyFull)(selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id, query);
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching full agent policy');
        }
        setFullAgentPolicy(res.data.item);
      } catch (error) {
        notifications.toasts.addError(error, {
          title: 'Error'
        });
      }
    }
    if (isK8s !== 'IS_LOADING') {
      fetchFullPolicy();
    }
  }, [selectedPolicy, notifications.toasts, isK8s, core.http.basePath]);
  (0, _react.useEffect)(() => {
    if (!fullAgentPolicy) {
      return;
    }
    if (isK8s === 'IS_KUBERNETES') {
      if (typeof fullAgentPolicy === 'object') {
        return;
      }
      setYaml(fullAgentPolicy);
    } else {
      if (typeof fullAgentPolicy === 'string') {
        return;
      }
      setYaml((0, _services.fullAgentPolicyToYaml)(fullAgentPolicy, _jsYaml.safeDump));
    }
  }, [fullAgentPolicy, isK8s]);
  const agentVersion = (0, _hooks.useAgentVersion)();
  const instructionsSteps = (0, _react.useMemo)(() => {
    const standaloneInstallCommands = (0, _enrollment_instructions.StandaloneInstructions)(agentVersion || '');
    const steps = !agentPolicy ? [(0, _.AgentPolicySelectionStep)({
      selectedPolicy,
      agentPolicies,
      selectedApiKeyId,
      setSelectedAPIKeyId,
      setSelectedPolicyId,
      refreshAgentPolicies
    })] : [];
    if (selectionType === 'radio') {
      steps.push((0, _.InstallationModeSelectionStep)({
        selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
        mode,
        setMode
      }));
    }
    steps.push((0, _.ConfigureStandaloneAgentStep)({
      isK8s,
      selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
      yaml,
      downloadLink
    }));
    steps.push((0, _.InstallStandaloneAgentStep)({
      installCommand: standaloneInstallCommands,
      isK8s,
      cloudSecurityIntegration
    }));
    return steps;
  }, [agentVersion, isK8s, cloudSecurityIntegration, agentPolicy, selectedPolicy, agentPolicies, selectedApiKeyId, setSelectedAPIKeyId, setSelectedPolicyId, refreshAgentPolicies, selectionType, yaml, downloadLink, mode, setMode]);
  if (!agentVersion) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: instructionsSteps
  });
};
exports.StandaloneSteps = StandaloneSteps;
const ManagedSteps = ({
  agentPolicy,
  agentPolicies,
  selectedPolicy,
  setSelectedPolicyId,
  selectedApiKeyId,
  setSelectedAPIKeyId,
  fleetServerHosts,
  fleetProxy,
  refreshAgentPolicies,
  mode,
  setMode,
  selectionType,
  onClickViewAgents,
  isK8s,
  cloudSecurityIntegration,
  installedPackagePolicy
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    docLinks
  } = core;
  const link = docLinks.links.fleet.troubleshooting;
  const [agentDataConfirmed, setAgentDataConfirmed] = (0, _react.useState)(false);
  const apiKey = (0, _hooks.useGetOneEnrollmentAPIKey)(selectedApiKeyId);
  const apiKeyData = apiKey === null || apiKey === void 0 ? void 0 : apiKey.data;
  const enrollToken = apiKey.data ? apiKey.data.item.api_key : '';
  const enrolledAgentIds = (0, _confirm_agent_enrollment.usePollingAgentCount)((selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id) || '');
  const agentVersion = (0, _hooks.useAgentVersion)();
  const {
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType
  } = (0, _services.getGcpIntegrationDetailsFromAgentPolicy)(selectedPolicy);
  const fleetServerHost = fleetServerHosts === null || fleetServerHosts === void 0 ? void 0 : fleetServerHosts[0];
  const installManagedCommands = (0, _enrollment_instructions.ManualInstructions)({
    apiKey: enrollToken,
    fleetServerHosts,
    fleetProxy,
    agentVersion: agentVersion || '',
    gcpProjectId,
    gcpOrganizationId,
    gcpAccountType
  });
  const instructionsSteps = (0, _react.useMemo)(() => {
    const steps = !agentPolicy ? [(0, _.AgentPolicySelectionStep)({
      selectedPolicy,
      agentPolicies,
      selectedApiKeyId,
      setSelectedAPIKeyId,
      setSelectedPolicyId,
      refreshAgentPolicies
    })] : [(0, _.AgentEnrollmentKeySelectionStep)({
      selectedPolicy,
      selectedApiKeyId,
      setSelectedAPIKeyId
    })];
    if (selectionType === 'radio') {
      steps.push((0, _.InstallationModeSelectionStep)({
        selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
        mode,
        setMode
      }));
    }
    if (cloudSecurityIntegration !== null && cloudSecurityIntegration !== void 0 && cloudSecurityIntegration.isCloudFormation) {
      steps.push((0, _.InstallCloudFormationManagedAgentStep)({
        apiKeyData,
        selectedApiKeyId,
        enrollToken,
        cloudSecurityIntegration,
        fleetServerHost
      }));
    } else if (cloudSecurityIntegration !== null && cloudSecurityIntegration !== void 0 && cloudSecurityIntegration.cloudShellUrl) {
      steps.push((0, _.InstallGoogleCloudShellManagedAgentStep)({
        apiKeyData,
        selectedApiKeyId,
        cloudShellUrl: cloudSecurityIntegration.cloudShellUrl,
        cloudShellCommand: installManagedCommands.googleCloudShell,
        projectId: gcpProjectId
      }));
    } else if (cloudSecurityIntegration !== null && cloudSecurityIntegration !== void 0 && cloudSecurityIntegration.isAzureArmTemplate) {
      steps.push((0, _.InstallAzureArmTemplateManagedAgentStep)({
        selectedApiKeyId,
        apiKeyData,
        enrollToken,
        cloudSecurityIntegration,
        agentPolicy
      }));
    } else {
      steps.push((0, _.InstallManagedAgentStep)({
        installCommand: installManagedCommands,
        apiKeyData,
        selectedApiKeyId,
        isK8s,
        cloudSecurityIntegration,
        fleetServerHost,
        enrollToken
      }));
    }
    if (selectedApiKeyId && apiKeyData) {
      steps.push((0, _.AgentEnrollmentConfirmationStep)({
        selectedPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
        onClickViewAgents,
        troubleshootLink: link,
        agentCount: enrolledAgentIds.length,
        isLongEnrollment: cloudSecurityIntegration !== undefined
      }));
    }
    if (selectedPolicy) {
      steps.push((0, _.IncomingDataConfirmationStep)({
        agentIds: enrolledAgentIds,
        agentDataConfirmed,
        setAgentDataConfirmed,
        installedPolicy: installedPackagePolicy,
        troubleshootLink: link
      }));
    }
    return steps;
  }, [agentPolicy, selectedPolicy, agentPolicies, selectedApiKeyId, setSelectedAPIKeyId, setSelectedPolicyId, refreshAgentPolicies, selectionType, cloudSecurityIntegration, apiKeyData, mode, setMode, enrollToken, installManagedCommands, isK8s, fleetServerHost, onClickViewAgents, link, enrolledAgentIds, agentDataConfirmed, installedPackagePolicy, gcpProjectId]);
  if (!agentVersion) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: instructionsSteps
  });
};
exports.ManagedSteps = ManagedSteps;