"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationLabels = getIntegrationLabels;
exports.mapToCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _has_deferred_installations = require("../../../../../../services/has_deferred_installations");
var _services = require("../../../../../../../common/services");
var _constants = require("../../../../../../../common/constants");
var _services2 = require("../../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapToCard = ({
  getAbsolutePath,
  getHref,
  item,
  addBasePath,
  packageVerificationKeyId,
  selectedCategory
}) => {
  let uiInternalPathUrl;
  let isUnverified = false;
  let version = 'version' in item ? item.version || '' : '';
  let isUpdateAvailable = false;
  let isReauthorizationRequired = false;
  if (item.type === 'ui_link') {
    uiInternalPathUrl = item.id.includes('language_client.') ? addBasePath(item.uiInternalPath) : item.uiExternalLink || getAbsolutePath(item.uiInternalPath);
  } else {
    var _item$installationInf;
    if (item !== null && item !== void 0 && (_item$installationInf = item.installationInfo) !== null && _item$installationInf !== void 0 && _item$installationInf.version) {
      version = item.installationInfo.version || item.version;
      isUnverified = (0, _services2.isPackageUnverified)(item, packageVerificationKeyId);
      isUpdateAvailable = (0, _services2.isPackageUpdatable)(item);
      isReauthorizationRequired = (0, _has_deferred_installations.hasDeferredInstallations)(item);
    }
    const url = getHref('integration_details_overview', {
      pkgkey: `${item.name}-${version}`,
      ...(item.integration ? {
        integration: item.integration
      } : {})
    });
    uiInternalPathUrl = url;
  }
  const release = (0, _services.getPackageReleaseLabel)(version);
  let extraLabelsBadges;
  if (item.type === 'integration') {
    extraLabelsBadges = getIntegrationLabels(item);
  }
  return {
    id: `${item.type === 'ui_link' ? 'ui_link' : 'epr'}:${item.id}`,
    description: item.description,
    icons: !item.icons || !item.icons.length ? [] : item.icons,
    title: item.title,
    url: uiInternalPathUrl,
    fromIntegrations: selectedCategory,
    integration: 'integration' in item ? item.integration || '' : '',
    name: 'name' in item ? item.name : item.id,
    version,
    release,
    categories: (item.categories || []).filter(c => !!c),
    isReauthorizationRequired,
    isUnverified,
    isUpdateAvailable,
    extraLabelsBadges
  };
};
exports.mapToCard = mapToCard;
function getIntegrationLabels(item) {
  var _item$installationInf2, _item$installationInf3, _item$installationInf6;
  const extraLabelsBadges = [];
  if (item !== null && item !== void 0 && (_item$installationInf2 = item.installationInfo) !== null && _item$installationInf2 !== void 0 && (_item$installationInf3 = _item$installationInf2.latest_install_failed_attempts) !== null && _item$installationInf3 !== void 0 && _item$installationInf3.some(attempt => item.installationInfo && (0, _lt.default)(item.installationInfo.version, attempt.target_version))) {
    var _item$installationInf4, _item$installationInf5;
    const updateFailedAttempt = (_item$installationInf4 = item.installationInfo) === null || _item$installationInf4 === void 0 ? void 0 : (_item$installationInf5 = _item$installationInf4.latest_install_failed_attempts) === null || _item$installationInf5 === void 0 ? void 0 : _item$installationInf5.find(attempt => item.installationInfo && (0, _lt.default)(item.installationInfo.version, attempt.target_version));
    extraLabelsBadges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: "update_failed_badge",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packageCard.updateFailedTooltipTitle",
        defaultMessage: "Update failed"
      }),
      content: updateFailedAttempt ? formatAttempt(updateFailedAttempt) : undefined
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.updateFailed",
      defaultMessage: "Update failed"
    }))))));
  }
  if (((_item$installationInf6 = item.installationInfo) === null || _item$installationInf6 === void 0 ? void 0 : _item$installationInf6.install_status) === _constants.installationStatuses.InstallFailed) {
    var _item$installationInf7, _item$installationInf8;
    const installFailedAttempt = (_item$installationInf7 = item.installationInfo) === null || _item$installationInf7 === void 0 ? void 0 : (_item$installationInf8 = _item$installationInf7.latest_install_failed_attempts) === null || _item$installationInf8 === void 0 ? void 0 : _item$installationInf8.find(attempt => {
      var _item$installationInf9;
      return attempt.target_version === ((_item$installationInf9 = item.installationInfo) === null || _item$installationInf9 === void 0 ? void 0 : _item$installationInf9.version);
    });
    extraLabelsBadges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: "install_failed_badge",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packageCard.installFailedTooltipTitle",
        defaultMessage: "Install failed"
      }),
      content: installFailedAttempt ? formatAttempt(installFailedAttempt) : undefined
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.installFailed",
      defaultMessage: "Install failed"
    }))))));
  }
  return extraLabelsBadges;
}
function formatAttempt(attempt) {
  var _attempt$error, _attempt$error2;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packageCard.faileAttemptDescription",
    defaultMessage: "Failed at {attemptDate}.",
    values: {
      attemptDate: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: attempt.created_at,
        year: "numeric",
        month: "short",
        day: "numeric"
      }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " @ "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: attempt.created_at,
        hour: "numeric",
        minute: "numeric",
        second: "numeric"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement("p", null, ((_attempt$error = attempt.error) === null || _attempt$error === void 0 ? void 0 : _attempt$error.name) || '', " : ", ((_attempt$error2 = attempt.error) === null || _attempt$error2 === void 0 ? void 0 : _attempt$error2.message) || ''));
}