"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._promoteFeaturedIntegrations = _promoteFeaturedIntegrations;
exports.promoteFeaturedIntegrations = void 0;
var _partition = _interopRequireDefault(require("lodash/partition"));
var _common = require("@kbn/custom-integrations-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// exported for testing
function _promoteFeaturedIntegrations(featuredIntegrationsByCategory, packageList, selectedCategory) {
  const featuredIntegrationNames = featuredIntegrationsByCategory[selectedCategory];
  if (!featuredIntegrationNames) return packageList;
  const [featuredIntegrations, otherIntegrations] = (0, _partition.default)(packageList, card => featuredIntegrationNames.includes(card.name));

  // now return the integrations in the order they are defined in
  const orderedFeaturedIntegrations = featuredIntegrationNames.map(integrationName => featuredIntegrations.find(({
    name
  }) => name === integrationName)).filter(v => v);
  return [...orderedFeaturedIntegrations, ...otherIntegrations];
}
const promoteFeaturedIntegrations = _promoteFeaturedIntegrations.bind(null, _common.FEATURED_INTEGRATIONS_BY_CATEGORY);
exports.promoteFeaturedIntegrations = promoteFeaturedIntegrations;