"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingIntegrationContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MissingIntegrationContent = ({
  resetQuery,
  setSelectedCategory,
  setUrlandPushHistory
}) => {
  const handleCustomInputsLinkClick = (0, _react.useCallback)(() => {
    resetQuery();
    setSelectedCategory('custom');
    setUrlandPushHistory({
      categoryId: 'custom',
      subCategoryId: ''
    });
  }, [resetQuery, setSelectedCategory, setUrlandPushHistory]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.missing",
    defaultMessage: "Don't see an integration? Collect any logs or metrics using our {customInputsLink}. Request new integrations in our {forumLink}.",
    values: {
      customInputsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: handleCustomInputsLinkClick
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrations.customInputsLink",
        defaultMessage: "custom inputs"
      })),
      forumLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://discuss.elastic.co/tag/integrations",
        external: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrations.discussForumLink",
        defaultMessage: "forum"
      }))
    }
  })));
};
exports.MissingIntegrationContent = MissingIntegrationContent;