"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostsFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _multi_row_input = require("../multi_row_input");
var _hooks = require("../../../../hooks");
var _constants = require("../../constants");
var _form = require("../form");
var _use_fleet_server_host_form = require("./use_fleet_server_host_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerHostsFlyout = ({
  onClose,
  fleetServerHost,
  proxies
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const form = (0, _use_fleet_server_host_form.useFleetServerHostsForm)(fleetServerHost, onClose);
  const {
    inputs
  } = form;
  const proxiesOptions = (0, _react.useMemo)(() => proxies.map(proxy => ({
    value: proxy.id,
    label: proxy.name
  })), [proxies]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: _constants.FLYOUT_MAX_WIDTH,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, fleetServerHost ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.editTitle",
    defaultMessage: "Edit Fleet Server"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.addTitle",
    defaultMessage: "Add Fleet Server"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",
      defaultMessage: "Changing these settings can break your agent connections"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",
    defaultMessage: "Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: form.submit
  }, /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",
      defaultMessage: "Name"
    }),
    inputProps: inputs.nameInput,
    dataTestSubj: "fleetServerHostsFlyout.nameInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",
      defaultMessage: "URL"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "relative"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.description",
    defaultMessage: "Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.settingsFleetServerHostSettings,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({}, form.inputs.hostUrlsInput.props, {
    id: "fleet-server-inputs",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",
      defaultMessage: "Proxy"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "fleetServerHostsFlyout.proxyIdInput"
  }, inputs.proxyIdInput.props, {
    onChange: options => {
      var _options$0$value, _options$;
      return inputs.proxyIdInput.setValue((_options$0$value = options === null || options === void 0 ? void 0 : (_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value) !== null && _options$0$value !== void 0 ? _options$0$value : '');
    },
    selectedOptions: inputs.proxyIdInput.value !== '' ? proxiesOptions.filter(option => option.value === inputs.proxyIdInput.value) : [],
    options: proxiesOptions,
    singleSelection: {
      asPlainText: true
    },
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder', {
      defaultMessage: 'Select proxy'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one."
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "saveApplySettingsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.saveButton",
    defaultMessage: "Save and apply settings"
  }))))));
};
exports.FleetServerHostsFlyout = FleetServerHostsFlyout;