"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputHealth = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_INTERVAL_MS = 10000;
const OutputHealth = ({
  output,
  showBadge
}) => {
  var _output$hosts$join, _output$hosts;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [outputHealth, setOutputHealth] = (0, _react.useState)();
  const {
    data: outputHealthResponse
  } = (0, _reactQuery.useQuery)(['outputHealth', output.id], () => (0, _hooks.sendGetOutputHealth)(output.id), {
    refetchInterval: REFRESH_INTERVAL_MS
  });
  (0, _react.useEffect)(() => {
    if (outputHealthResponse !== null && outputHealthResponse !== void 0 && outputHealthResponse.error) {
      notifications.toasts.addError(outputHealthResponse === null || outputHealthResponse === void 0 ? void 0 : outputHealthResponse.error, {
        title: _i18n.i18n.translate('xpack.fleet.output.errorFetchingOutputHealth', {
          defaultMessage: 'Error fetching output state'
        })
      });
    }
    setOutputHealth(outputHealthResponse === null || outputHealthResponse === void 0 ? void 0 : outputHealthResponse.data);
  }, [outputHealthResponse, notifications.toasts]);
  const EditOutputStatus = {
    DEGRADED: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Error",
      color: "danger",
      iconType: "error",
      "data-test-subj": "outputHealthDegradedCallout"
    }, /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord"
    }, _i18n.i18n.translate('xpack.fleet.output.calloutText', {
      defaultMessage: 'Unable to connect to "{name}" at {host}.',
      values: {
        name: output.name,
        host: (_output$hosts$join = (_output$hosts = output.hosts) === null || _output$hosts === void 0 ? void 0 : _output$hosts.join(',')) !== null && _output$hosts$join !== void 0 ? _output$hosts$join : ''
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.fleet.output.calloutPromptText', {
      defaultMessage: 'Please check the details are correct.'
    }))),
    HEALTHY: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Healthy",
      color: "success",
      iconType: "check",
      "data-test-subj": "outputHealthHealthyCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.fleet.output.successCalloutText', {
      defaultMessage: 'Connection with remote output established.'
    })))
  };
  const OutputStatusBadge = {
    DEGRADED: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      "data-test-subj": "outputHealthDegradedBadge"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.outputHealth.degradedStatusText",
      defaultMessage: "Unhealthy"
    })),
    HEALTHY: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      "data-test-subj": "outputHealthHealthyBadge"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.outputHealth.healthyStatusText",
      defaultMessage: "Healthy"
    }))
  };
  const msLastTimestamp = new Date((outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.timestamp) || 0).getTime();
  const lastTimestampText = msLastTimestamp ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.outputHealth.timestampTooltipText",
    defaultMessage: "Last reported {timestamp}",
    values: {
      timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: msLastTimestamp
      })
    }
  })) : null;
  const outputBadge = (outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.state) && OutputStatusBadge[outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.state] || null;
  return showBadge ? lastTimestampText && outputHealth !== null && outputHealth !== void 0 && outputHealth.state ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: lastTimestampText,
    "data-test-subj": "outputHealthBadgeTooltip"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, outputBadge, " ")) : outputBadge : (outputHealth === null || outputHealth === void 0 ? void 0 : outputHealth.state) && EditOutputStatus[outputHealth.state] || null;
};
exports.OutputHealth = OutputHealth;