"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _use_apm_service_href = require("../../../../hooks/use_apm_service_href");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamRowActions = /*#__PURE__*/(0, _react.memo)(({
  datastream
}) => {
  const {
    dashboards
  } = datastream;
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const actionNameSingular = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.dataStreamList.viewDashboardActionText",
    defaultMessage: "View dashboard"
  });
  const actionNamePlural = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.dataStreamList.viewDashboardsActionText",
    defaultMessage: "View dashboards"
  });
  const panelTitle = _i18n.i18n.translate('xpack.fleet.dataStreamList.viewDashboardsPanelTitle', {
    defaultMessage: 'View dashboards'
  });
  const viewServiceInApmActionTitle = _i18n.i18n.translate('xpack.fleet.dataStreamList.viewInApmActionText', {
    defaultMessage: 'View in APM'
  });
  const {
    isSuccessful,
    href
  } = (0, _use_apm_service_href.useAPMServiceDetailHref)(datastream);
  if (isSuccessful && href) {
    const apmItem = [{
      id: 0,
      items: [{
        icon: 'apmApp',
        href,
        name: viewServiceInApmActionTitle
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      panels: apmItem
    });
  }
  if (!dashboards || dashboards.length === 0) {
    const disabledItems = [{
      id: 0,
      items: [{
        icon: 'dashboardApp',
        disabled: true,
        name: actionNameSingular
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      panels: disabledItems
    });
  }
  if (dashboards.length === 1) {
    var _dashboards$;
    const panelItems = [{
      id: 0,
      items: [{
        icon: 'dashboardApp',
        href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
          dashboardId: (_dashboards$ = dashboards[0]) === null || _dashboards$ === void 0 ? void 0 : _dashboards$.id
        } || ''),
        name: actionNameSingular
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      panels: panelItems
    });
  }
  const panelItems = [{
    id: 0,
    items: [{
      icon: 'dashboardApp',
      panel: 1,
      name: actionNamePlural
    }]
  }, {
    id: 1,
    title: panelTitle,
    items: dashboards.map(dashboard => {
      return {
        icon: 'dashboardApp',
        href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
          dashboardId: dashboard === null || dashboard === void 0 ? void 0 : dashboard.id
        } || ''),
        name: dashboard.title
      };
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    panels: panelItems
  });
});
exports.DataStreamRowActions = DataStreamRowActions;