"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallTokenListPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _api_key_field = require("../../../../../components/api_key_field");
var _uninstall_tokens = require("../../../../../hooks/use_request/uninstall_tokens");
var _hooks = require("../../../hooks");
var _layouts = require("../../../layouts");
var _components = require("../../../components");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyIdField = ({
  policyId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  className: "eui-textTruncate",
  title: policyId,
  "data-test-subj": "uninstallTokensPolicyIdField"
}, policyId);
const ViewUninstallCommandButton = ({
  onClick
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: _translations.VIEW_UNINSTALL_COMMAND_LABEL
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "data-test-subj": "uninstallTokensViewCommandButton",
  "aria-label": _translations.VIEW_UNINSTALL_COMMAND_LABEL,
  onClick: onClick,
  iconType: "inspect",
  color: "text"
}));
const NoItemsMessage = ({
  isLoading
}) => isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.uninstallTokenList.loadingTokensMessage",
  defaultMessage: "Loading uninstall tokens..."
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.uninstallTokenList.emptyMessage",
  defaultMessage: "No uninstall tokens found."
});
const UninstallTokenListPage = () => {
  var _data$items, _data$total;
  (0, _hooks.useBreadcrumbs)('uninstall_tokens');
  const [policyIdSearch, setPolicyIdSearch] = (0, _react.useState)('');
  const [tokenIdForFlyout, setTokenIdForFlyout] = (0, _react.useState)(null);
  const {
    pagination,
    setPagination,
    pageSizeOptions
  } = (0, _hooks.usePagination)();
  const {
    isLoading,
    data
  } = (0, _uninstall_tokens.useGetUninstallTokens)({
    perPage: pagination.pageSize,
    page: pagination.currentPage,
    policyId: policyIdSearch
  });
  const tokens = (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [];
  const total = (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0;
  const columns = (0, _react.useMemo)(() => [{
    field: 'policy_id',
    name: _translations.POLICY_ID_TITLE,
    render: policyId => /*#__PURE__*/_react.default.createElement(PolicyIdField, {
      policyId: policyId
    })
  }, {
    field: 'created_at',
    name: _translations.CREATED_AT_TITLE,
    width: '130px',
    render: createdAt => createdAt ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      year: "numeric",
      month: "short",
      day: "2-digit",
      value: createdAt
    }) : null
  }, {
    field: 'id',
    name: _translations.TOKEN_TITLE,
    width: '300px',
    render: uninstallTokenId => /*#__PURE__*/_react.default.createElement(_api_key_field.ApiKeyField, {
      apiKeyId: uninstallTokenId,
      sendGetAPIKey: _uninstall_tokens.sendGetUninstallToken,
      tokenGetter: response => {
        var _response$data;
        return (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.item.token;
      },
      length: 32
    })
  }, {
    field: 'actions',
    name: _translations.ACTIONS_TITLE,
    align: 'center',
    width: '70px',
    render: (_, {
      id
    }) => /*#__PURE__*/_react.default.createElement(ViewUninstallCommandButton, {
      onClick: () => setTokenIdForFlyout(id)
    })
  }], []);
  const handleTablePagination = (0, _react.useCallback)(({
    page
  }) => {
    setPagination(prevPagination => ({
      ...prevPagination,
      currentPage: page.index + 1,
      pageSize: page.size
    }));
  }, [setPagination]);
  const handleSearch = (0, _react.useCallback)(searchString => {
    setPolicyIdSearch(searchString);
    setPagination(prevPagination => ({
      ...prevPagination,
      currentPage: 1
    }));
  }, [setPagination]);
  return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "uninstall_tokens"
  }, tokenIdForFlyout && /*#__PURE__*/_react.default.createElement(_components.UninstallCommandFlyout, {
    onClose: () => setTokenIdForFlyout(null),
    target: "agent",
    uninstallTokenId: tokenIdForFlyout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.uninstallTokenList.pageDescription",
    defaultMessage: "Uninstall token allows you to get the uninstall command if you need to uninstall the Agent/Endpoint on the Host."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    onSearch: handleSearch,
    incremental: true,
    fullWidth: true,
    placeholder: _translations.SEARCH_BY_POLICY_ID_PLACEHOLDER,
    "data-test-subj": "uninstallTokensPolicyIdSearchInput"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "uninstallTokenListTable",
    items: tokens,
    columns: columns,
    itemId: "id",
    loading: isLoading,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: total,
      pageSizeOptions
    },
    onChange: handleTablePagination,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(NoItemsMessage, {
      isLoading: isLoading
    }),
    hasActions: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
};
exports.UninstallTokenListPage = UninstallTokenListPage;