"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentRequestDiagnosticsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentRequestDiagnosticsModal = ({
  onClose,
  agents,
  agentCount
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const isSingleAgent = Array.isArray(agents) && agents.length === 1;
  const {
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  async function onSubmit() {
    try {
      setIsSubmitting(true);
      const {
        error
      } = isSingleAgent ? await (0, _hooks.sendPostRequestDiagnostics)(agents[0].id) : await (0, _hooks.sendPostBulkRequestDiagnostics)({
        agents: typeof agents === 'string' ? agents : agents.map(agent => agent.id)
      });
      if (error) {
        throw error;
      }
      setIsSubmitting(false);
      const successMessage = _i18n.i18n.translate('xpack.fleet.requestDiagnostics.successSingleNotificationTitle', {
        defaultMessage: 'Request diagnostics submitted'
      });
      notifications.toasts.addSuccess(successMessage);
      if (isSingleAgent) {
        const path = getPath('agent_details_diagnostics', {
          agentId: agents[0].id
        });
        history.push(path);
      }
      onClose();
    } catch (error) {
      setIsSubmitting(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle', {
          defaultMessage: 'Error requesting diagnostics {count, plural, one {agent} other {agents}}',
          values: {
            count: agentCount
          }
        })
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "requestDiagnosticsModal",
    title: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.singleTitle",
      defaultMessage: "Request diagnostics"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.multipleTitle",
      defaultMessage: "Request diagnostics for {count} agents",
      values: {
        count: agentCount
      }
    }),
    onCancel: onClose,
    onConfirm: onSubmit,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonDisabled: isSubmitting,
    confirmButtonText: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.confirmSingleButtonLabel",
      defaultMessage: "Request diagnostics"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.confirmMultipleButtonLabel",
      defaultMessage: "Request diagnostics for {count} agents",
      values: {
        count: agentCount
      }
    }),
    buttonColor: "primary"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.requestDiagnostics.description",
    defaultMessage: "Diagnostics files are stored in Elasticsearch, and as such can incur storage costs."
  })));
};
exports.AgentRequestDiagnosticsModal = AgentRequestDiagnosticsModal;