"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _components3 = require("../components");
var _components4 = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyListPage = () => {
  var _urlParams$kuery, _agentPolicyData$tota;
  (0, _hooks.useBreadcrumbs)('policies_list');
  const {
    getPath
  } = (0, _hooks.useLink)();
  const hasFleetAllPrivileges = (0, _hooks.useAuthz)().fleet.all;
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();

  // Table and search states
  const {
    urlParams,
    toUrlParams
  } = (0, _hooks.useUrlParams)();
  const [search, setSearch] = (0, _react.useState)(Array.isArray(urlParams.kuery) ? urlParams.kuery[urlParams.kuery.length - 1] : (_urlParams$kuery = urlParams.kuery) !== null && _urlParams$kuery !== void 0 ? _urlParams$kuery : '');
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _hooks.usePagination)();
  const {
    sorting,
    setSorting
  } = (0, _hooks.useSorting)({
    field: 'updated_at',
    direction: 'desc'
  });
  const history = (0, _reactRouterDom.useHistory)();
  const isCreateAgentPolicyFlyoutOpen = ('create' in urlParams);
  const setIsCreateAgentPolicyFlyoutOpen = (0, _react.useCallback)(isOpen => {
    if (isOpen !== isCreateAgentPolicyFlyoutOpen) {
      if (isOpen) {
        history.push(`${getPath('policies_list')}?${toUrlParams({
          ...urlParams,
          create: null
        })}`);
      } else {
        const {
          create,
          ...params
        } = urlParams;
        history.push(`${getPath('policies_list')}?${toUrlParams(params)}`);
      }
    }
  }, [getPath, history, isCreateAgentPolicyFlyoutOpen, toUrlParams, urlParams]);

  // Fetch agent policies
  const {
    isLoading,
    data: agentPolicyData,
    resendRequest
  } = (0, _hooks.useGetAgentPolicies)({
    page: pagination.currentPage,
    perPage: pagination.pageSize,
    sortField: sorting === null || sorting === void 0 ? void 0 : sorting.field,
    sortOrder: sorting === null || sorting === void 0 ? void 0 : sorting.direction,
    kuery: search,
    full: true
  });

  // Some policies retrieved, set up table props
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      field: 'name',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      width: '25%',
      render: (name, agentPolicy) => /*#__PURE__*/_react.default.createElement(_components2.AgentPolicySummaryLine, {
        policy: agentPolicy
      })
    }, {
      field: 'description',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.descriptionColumnTitle', {
        defaultMessage: 'Description'
      }),
      width: '35%',
      render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        className: "eui-textTruncate",
        title: value
      }, value)
    }, {
      field: 'updated_at',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.updatedOnColumnTitle', {
        defaultMessage: 'Last updated on'
      }),
      render: date => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: date,
        year: "numeric",
        month: "short",
        day: "2-digit"
      })
    }, {
      field: 'agents',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.agentsColumnTitle', {
        defaultMessage: 'Agents'
      }),
      dataType: 'number',
      render: (agents, agentPolicy) => /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
        count: agents,
        agentPolicyId: agentPolicy.id
      })
    }, {
      field: 'package_policies',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle', {
        defaultMessage: 'Integrations'
      }),
      dataType: 'number',
      render: packagePolicies => packagePolicies ? packagePolicies.length : 0
    }, {
      field: 'actions',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: agentPolicy => /*#__PURE__*/_react.default.createElement(_components3.AgentPolicyActionMenu, {
          agentPolicy: agentPolicy,
          onCopySuccess: () => resendRequest()
        })
      }]
    }];

    // If Fleet is not enabled, then remove the `agents` column
    if (!isFleetEnabled) {
      return cols.filter(col => 'field' in col ? col.field !== 'agents' : true);
    }
    return cols;
  }, [isFleetEnabled, resendRequest]);
  const createAgentPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !hasFleetAllPrivileges,
    onClick: () => setIsCreateAgentPolicyFlyoutOpen(true),
    "data-test-subj": "createAgentPolicyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.addButton",
    defaultMessage: "Create agent policy"
  })), [hasFleetAllPrivileges, setIsCreateAgentPolicyFlyoutOpen]);
  const emptyStateCreateAgentPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !hasFleetAllPrivileges,
    onClick: () => setIsCreateAgentPolicyFlyoutOpen(true),
    "data-test-subj": "emptyPromptCreateAgentPolicyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.addButton",
    defaultMessage: "Create agent policy"
  })), [hasFleetAllPrivileges, setIsCreateAgentPolicyFlyoutOpen]);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",
      defaultMessage: "No agent policies"
    })),
    actions: emptyStateCreateAgentPolicyButton
  }), [emptyStateCreateAgentPolicyButton]);
  const onTableChange = criteria => {
    const newPagination = {
      ...pagination,
      currentPage: criteria.page.index + 1,
      pageSize: criteria.page.size
    };
    setPagination(newPagination);
    setSorting(criteria.sort);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCreateAgentPolicyFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_components4.CreateAgentPolicyFlyout, {
    onClose: () => {
      setIsCreateAgentPolicyFlyoutOpen(false);
      resendRequest();
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_components.SearchBar, {
    value: search,
    onChange: newSearch => {
      setPagination({
        ...pagination,
        currentPage: 1
      });
      setSearch(newSearch);
    },
    indexPattern: `.${_constants.AGENT_POLICY_SAVED_OBJECT_TYPE}`,
    fieldPrefix: _constants.AGENT_POLICY_SAVED_OBJECT_TYPE,
    dataTestSubj: "agentPolicyList.queryInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "refresh",
    onClick: () => resendRequest()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",
    defaultMessage: "Reload"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, createAgentPolicyButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    hasActions: true,
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",
      defaultMessage: "Loading agent policies\u2026"
    }) : !search.trim() && ((_agentPolicyData$tota = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.total) !== null && _agentPolicyData$tota !== void 0 ? _agentPolicyData$tota : 0) === 0 ? emptyPrompt : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",
      defaultMessage: "No agent policies found. {clearFiltersLink}",
      values: {
        clearFiltersLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => setSearch('')
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.clearFiltersLinkText",
          defaultMessage: "Clear filters"
        }))
      }
    }),
    items: agentPolicyData ? agentPolicyData.items : [],
    itemId: "id",
    columns: columns,
    isSelectable: false,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: agentPolicyData ? agentPolicyData.total : 0,
      pageSizeOptions
    },
    sorting: {
      sort: sorting
    },
    onChange: onTableChange
  }));
};
exports.AgentPolicyListPage = AgentPolicyListPage;