"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFirstIntegrationSplashScreen = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../components");
var _components2 = require("../../../../../components");
var _services = require("../../../../../services");
var _layouts = require("../../../../../layouts");
var _hooks = require("../../../../../hooks");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CentralTitle = (0, _styledComponents.default)('h1')`
  text-align: center;
`;
const PaddedCentralTitle = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: 's'
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement(CentralTitle, null, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: 'xl'
}));
const SubtitleText = (0, _styledComponents.default)(_eui.EuiText)`
  max-width: 250px;
  margin: 0 auto;
  text-align: center;
`;
// step numbers are not centered in smaller layouts without this
const CenteredEuiStepNumber = (0, _styledComponents.default)(_eui.EuiStepNumber)`
  margin: 0 auto;
`;

// step numbers are not centered in smaller layouts without this
const CenteredEuiImage = props => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    margin: '0 auto'
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, props));
const ResponsiveStepGroup = ({
  children
}) => {
  const isScreenSmall = (0, _eui.useIsWithinMaxBreakpoint)('s');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: isScreenSmall ? 'xs' : 'l',
    alignItems: "center",
    justifyContent: "center",
    wrap: true
  }, children);
};
const AddIntegrationStepsIllustrations = () => {
  const {
    http
  } = (0, _hooks.useStartServices)();
  const assetsBasePath = http.basePath.prepend('/plugins/fleet/assets/');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceEvenly",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ResponsiveStepGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CenteredEuiStepNumber, {
    status: "incomplete",
    number: 1
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '0 auto'
    }
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "Illustration of installing the Elastic Agent",
    src: assetsBasePath + '1_install_agent.svg'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.installAgentStepTitle",
    defaultMessage: "Install Elastic Agent"
  }))), /*#__PURE__*/_react.default.createElement(SubtitleText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.installAgentStep",
    defaultMessage: "Install agents on the hosts that you want to connect to Elastic."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['s', 'xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['s', 'xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "Illustration of an arrow pointing from left to right",
    src: assetsBasePath + 'arrow_right_curve_over.svg'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ResponsiveStepGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CenteredEuiStepNumber, {
    status: "incomplete",
    number: 2
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "Illustration of adding an integration",
    src: assetsBasePath + '2_add_integration.svg'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.addIntegrationStepTitle",
    defaultMessage: "Add the integration"
  }))), /*#__PURE__*/_react.default.createElement(SubtitleText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.addIntegrationStep",
    defaultMessage: "Make a few selections to finalize how Elastic receives your data."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['s', 'xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['s', 'xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "Illustration of an arrow pointing from left to right",
    src: assetsBasePath + 'arrow_right_curve_under.svg'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ResponsiveStepGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CenteredEuiStepNumber, {
    status: "incomplete",
    number: 3
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CenteredEuiImage, {
    alt: "Illustration of a dashboard with data",
    src: assetsBasePath + '3_confirm_data.svg'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.confirmDataStepTitle",
    defaultMessage: "Confirm incoming data"
  }))), /*#__PURE__*/_react.default.createElement(SubtitleText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.confirmDataStep",
    defaultMessage: "Explore and analyze the incoming data."
  }))))));
};
const NotObscuredByBottomBar = (0, _styledComponents.default)('div')`
  padding-bottom: 100px;
`;
const CenteredLearnMoreLink = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.elasticAgent,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.learnMoreLink",
    defaultMessage: "Learn more about installing Elastic Agent"
  }))));
};
const AddFirstIntegrationSplashScreen = ({
  integrationInfo,
  packageInfo,
  isLoading,
  error,
  cancelUrl,
  cancelClickHandler,
  onNext
}) => {
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_components2.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.addFirstIntegrationSplash.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information"
      }),
      error: error
    });
  }
  const topContent = /*#__PURE__*/_react.default.createElement(PaddedCentralTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addFirstIntegrationSplash.pageTitle",
    defaultMessage: "Ready to add your first integration?"
  }));
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    topContent: topContent
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(AddIntegrationStepsIllustrations, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(NotObscuredByBottomBar, null, /*#__PURE__*/_react.default.createElement(CenteredLearnMoreLink, null)), /*#__PURE__*/_react.default.createElement(_.CreatePackagePolicyBottomBar, {
    cancelUrl: cancelUrl,
    cancelMessage: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "skipAgentInstallation"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicyBottomBar.skipAddAgentButton",
      defaultMessage: "Add integration only (skip agent installation)"
    })),
    cancelClickHandler: cancelClickHandler,
    isLoading: isLoading,
    onNext: onNext,
    noAnimation: true,
    actionMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addFirstIntegrationSplash.installAgentButton",
      defaultMessage: "Install Elastic Agent"
    })
  }), packageInfo && /*#__PURE__*/_react.default.createElement(_components.IntegrationBreadcrumb, {
    pkgTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
    pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo),
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name
  })));
};
exports.AddFirstIntegrationSplashScreen = AddFirstIntegrationSplashScreen;