"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataStreamId = useDataStreamId;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDataStreamId() {
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useMemo)(() => {
    var _searchParams$get;
    const searchParams = new URLSearchParams(history.location.search);
    return (_searchParams$get = searchParams.get('datastreamId')) !== null && _searchParams$get !== void 0 ? _searchParams$get : undefined;
  }, [history.location.search]);
}