"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outputType = exports.kafkaVerificationModes = exports.kafkaTopicWhenType = exports.kafkaSupportedVersions = exports.kafkaSaslMechanism = exports.kafkaPartitionType = exports.kafkaConnectionType = exports.kafkaCompressionType = exports.kafkaAuthType = exports.kafkaAcknowledgeReliabilityLevel = exports.RESERVED_CONFIG_YML_KEYS = exports.OUTPUT_TYPES_WITH_PRESET_SUPPORT = exports.OUTPUT_SAVED_OBJECT_TYPE = exports.OUTPUT_HEALTH_DATA_STREAM = exports.LICENCE_FOR_PER_POLICY_OUTPUT = exports.DEFAULT_OUTPUT_ID = exports.DEFAULT_OUTPUT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OUTPUT_SAVED_OBJECT_TYPE = 'ingest-outputs';
exports.OUTPUT_SAVED_OBJECT_TYPE = OUTPUT_SAVED_OBJECT_TYPE;
const outputType = {
  Elasticsearch: 'elasticsearch',
  Logstash: 'logstash',
  Kafka: 'kafka',
  RemoteElasticsearch: 'remote_elasticsearch'
};
exports.outputType = outputType;
const DEFAULT_OUTPUT_ID = 'fleet-default-output';
exports.DEFAULT_OUTPUT_ID = DEFAULT_OUTPUT_ID;
const DEFAULT_OUTPUT = {
  name: 'default',
  is_default: true,
  is_default_monitoring: true,
  type: outputType.Elasticsearch,
  hosts: ['']
};
exports.DEFAULT_OUTPUT = DEFAULT_OUTPUT;
const LICENCE_FOR_PER_POLICY_OUTPUT = 'platinum';

/**
 * Kafka constants
 */
exports.LICENCE_FOR_PER_POLICY_OUTPUT = LICENCE_FOR_PER_POLICY_OUTPUT;
const kafkaCompressionType = {
  None: 'none',
  Snappy: 'snappy',
  Lz4: 'lz4',
  Gzip: 'gzip'
};
exports.kafkaCompressionType = kafkaCompressionType;
const kafkaAuthType = {
  Userpass: 'user_pass',
  Ssl: 'ssl',
  Kerberos: 'kerberos',
  None: 'none'
};
exports.kafkaAuthType = kafkaAuthType;
const kafkaConnectionType = {
  Plaintext: 'plaintext',
  Encryption: 'encryption'
};
exports.kafkaConnectionType = kafkaConnectionType;
const kafkaSaslMechanism = {
  Plain: 'PLAIN',
  ScramSha256: 'SCRAM-SHA-256',
  ScramSha512: 'SCRAM-SHA-512'
};
exports.kafkaSaslMechanism = kafkaSaslMechanism;
const kafkaPartitionType = {
  Random: 'random',
  RoundRobin: 'round_robin',
  Hash: 'hash'
};
exports.kafkaPartitionType = kafkaPartitionType;
const kafkaTopicWhenType = {
  Equals: 'equals',
  Contains: 'contains',
  Regexp: 'regexp'
};
exports.kafkaTopicWhenType = kafkaTopicWhenType;
const kafkaAcknowledgeReliabilityLevel = {
  Commit: 1,
  Replica: -1,
  DoNotWait: 0
};
exports.kafkaAcknowledgeReliabilityLevel = kafkaAcknowledgeReliabilityLevel;
const kafkaVerificationModes = {
  Full: 'full',
  None: 'none',
  Strict: 'strict',
  Certificate: 'certificate'
};
exports.kafkaVerificationModes = kafkaVerificationModes;
const kafkaSupportedVersions = ['0.8.2.0', '0.8.2.1', '0.8.2.2', '0.9.0.0', '0.9.0.1', '0.10.0.0', '0.10.0.1', '0.10.1.0', '0.10.1.1', '0.10.2.0', '0.10.2.1', '0.10.2.2', '0.11.0.0', '0.11.0.1', '0.11.0.2', '0.11.0.3', '1.0.0', '1.0.1', '1.0.2', '1.1.0', '1.1.1', '2.0.0', '2.0.1', '2.1.0', '2.1.1', '2.2.0', '2.2.1', '2.2.2', '2.3.0', '2.3.1', '2.4.0', '2.4.1', '2.5.0', '2.5.1', '2.6.0'];
exports.kafkaSupportedVersions = kafkaSupportedVersions;
const RESERVED_CONFIG_YML_KEYS = ['bulk_max_size', 'compression_level', 'connection_idle_timeout', 'queue.mem.events', 'queue.mem.flush.min_events', 'queue.mem.flush.timeout', 'workers'];
exports.RESERVED_CONFIG_YML_KEYS = RESERVED_CONFIG_YML_KEYS;
const OUTPUT_TYPES_WITH_PRESET_SUPPORT = [outputType.Elasticsearch, outputType.RemoteElasticsearch];
exports.OUTPUT_TYPES_WITH_PRESET_SUPPORT = OUTPUT_TYPES_WITH_PRESET_SUPPORT;
const OUTPUT_HEALTH_DATA_STREAM = 'logs-fleet_server.output_health-default';
exports.OUTPUT_HEALTH_DATA_STREAM = OUTPUT_HEALTH_DATA_STREAM;