"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _contentManagementTableListView = require("@kbn/content-management-table-list-view");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _context = require("./context");
var _i18n_texts = require("./i18n_texts");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function naivelyFuzzify(query) {
  return query.includes('*') ? query : `*${query}*`;
}
const App = () => {
  const {
    filesClient,
    getFileKindDefinition,
    getAllFindKindDefinitions
  } = (0, _context.useFilesManagementContext)();
  const [showDiagnosticsFlyout, setShowDiagnosticsFlyout] = (0, _react.useState)(false);
  const [selectedFile, setSelectedFile] = (0, _react.useState)(undefined);
  const kindToExcludeFromSearch = getAllFindKindDefinitions().filter(({
    managementUiActions
  }) => {
    var _managementUiActions$;
    return (managementUiActions === null || managementUiActions === void 0 ? void 0 : (_managementUiActions$ = managementUiActions.list) === null || _managementUiActions$ === void 0 ? void 0 : _managementUiActions$.enabled) === false;
  }).map(({
    id
  }) => id);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "filesManagementApp"
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListView.TableListView, {
    title: _i18n_texts.i18nTexts.tableListTitle,
    description: _i18n_texts.i18nTexts.tableListDescription,
    titleColumnName: _i18n_texts.i18nTexts.titleColumnName,
    emptyPrompt: /*#__PURE__*/_react.default.createElement(_components.EmptyPrompt, null),
    entityName: _i18n_texts.i18nTexts.entityName,
    entityNamePlural: _i18n_texts.i18nTexts.entityNamePlural,
    findItems: searchQuery => filesClient.find({
      name: searchQuery ? naivelyFuzzify(searchQuery) : undefined,
      kindToExclude: kindToExcludeFromSearch
    }).then(({
      files,
      total
    }) => ({
      hits: files.map(file => ({
        id: file.id,
        updatedAt: file.updated,
        references: [],
        type: 'file',
        attributes: {
          title: file.name + (file.extension ? `.${file.extension}` : ''),
          ...file
        }
      })),
      total
    })),
    customTableColumn: {
      name: _i18n_texts.i18nTexts.size,
      field: 'attributes.size',
      render: value => value && (0, _numeral.default)(value).format('0[.]0 b'),
      sortable: true
    },
    initialFilter: "",
    initialPageSize: 50,
    listingLimit: 1000,
    onClickTitle: ({
      attributes
    }) => setSelectedFile(attributes),
    deleteItems: async items => {
      await filesClient.bulkDelete({
        ids: items.map(({
          id
        }) => id)
      });
    },
    withoutPageTemplateWrapper: true,
    additionalRightSideActions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setShowDiagnosticsFlyout(true)
    }, _i18n_texts.i18nTexts.diagnosticsFlyoutTitle)],
    rowItemActions: ({
      attributes
    }) => {
      var _definition$managemen;
      const definition = getFileKindDefinition(attributes.fileKind);
      return {
        delete: definition === null || definition === void 0 ? void 0 : (_definition$managemen = definition.managementUiActions) === null || _definition$managemen === void 0 ? void 0 : _definition$managemen.delete
      };
    }
  }), showDiagnosticsFlyout && /*#__PURE__*/_react.default.createElement(_components.DiagnosticsFlyout, {
    onClose: () => setShowDiagnosticsFlyout(false)
  }), Boolean(selectedFile) && /*#__PURE__*/_react.default.createElement(_components.FileFlyout, {
    file: selectedFile,
    onClose: () => setSelectedFile(undefined)
  }));
};
exports.App = App;