"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GEO_FILE_TYPES = void 0;
exports.geoImporterFactory = geoImporterFactory;
var _geojson_importer = require("./geojson_importer");
var _shapefile_importer = require("./shapefile_importer");
var _validate_file = require("../validate_file");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GEO_FILE_TYPES = [..._geojson_importer.GEOJSON_FILE_TYPES, ..._shapefile_importer.SHAPEFILE_TYPES];
exports.GEO_FILE_TYPES = GEO_FILE_TYPES;
const OPTIONS = {
  checkSizeLimit: false
};
function geoImporterFactory(file) {
  (0, _validate_file.validateFile)(file, GEO_FILE_TYPES, OPTIONS);
  const extension = (0, _validate_file.getFileExtension)(file);
  return _geojson_importer.GEOJSON_FILE_TYPES.includes(extension) ? new _geojson_importer.GeoJsonImporter(file) : new _shapefile_importer.ShapefileImporter(file);
}