"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanGeometry = cleanGeometry;
exports.geoJsonCleanAndValidate = geoJsonCleanAndValidate;
var jsts = _interopRequireWildcard(require("jsts"));
var _geojsonRewind = _interopRequireDefault(require("@mapbox/geojson-rewind"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The GeoJSON specification suggests limiting coordinate precision to six decimal places
// See https://datatracker.ietf.org/doc/html/rfc7946#section-11.2
// We can enforce rounding to six decimal places by setting the PrecisionModel scale
// scale = 10^n where n = maximum number of decimal places
const precisionModel = new jsts.geom.PrecisionModel(Math.pow(10, 6));
const geometryPrecisionReducer = new jsts.precision.GeometryPrecisionReducer(precisionModel);
geometryPrecisionReducer.setChangePrecisionModel(true);
const geoJSONReader = new jsts.io.GeoJSONReader();
const geoJSONWriter = new jsts.io.GeoJSONWriter();
function geoJsonCleanAndValidate(feature) {
  let cleanedGeometry;
  // Attempts to clean geometry. If this fails, don't generate errors at this
  // point, these will be handled more accurately on write to ES with feedback
  // given to user
  try {
    const geometryReadResult = geoJSONReader.read(feature);
    cleanedGeometry = cleanGeometry(geometryReadResult);
  } catch (e) {
    return feature;
  }

  // JSTS does not enforce winding order, wind in clockwise order
  const correctlyWindedGeometry = (0, _geojsonRewind.default)(cleanedGeometry, false);
  return {
    ...feature,
    geometry: correctlyWindedGeometry
  };
}
function cleanGeometry({
  geometry
}) {
  if (!geometry) {
    return null;
  }

  // GeometryPrecisionReducer will automatically clean invalid geometries
  const geometryToWrite = geometryPrecisionReducer.reduce(geometry);
  return geoJSONWriter.write(geometryToWrite);
}