"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = exports.ExpressionRenderHandler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _render_error_handler = require("./render_error_handler");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ExpressionRenderHandler {
  constructor(element, {
    onRenderError,
    renderMode,
    syncColors,
    syncTooltips,
    syncCursor,
    interactive,
    hasCompatibleActions = async () => false,
    getCompatibleCellValueActions = async () => [],
    executionContext
  } = {}) {
    (0, _defineProperty2.default)(this, "render$", void 0);
    (0, _defineProperty2.default)(this, "update$", void 0);
    (0, _defineProperty2.default)(this, "events$", void 0);
    (0, _defineProperty2.default)(this, "element", void 0);
    (0, _defineProperty2.default)(this, "destroyFn", void 0);
    (0, _defineProperty2.default)(this, "renderCount", 0);
    (0, _defineProperty2.default)(this, "renderSubject", void 0);
    (0, _defineProperty2.default)(this, "eventsSubject", void 0);
    (0, _defineProperty2.default)(this, "updateSubject", void 0);
    (0, _defineProperty2.default)(this, "handlers", void 0);
    (0, _defineProperty2.default)(this, "onRenderError", void 0);
    (0, _defineProperty2.default)(this, "render", async (value, uiState) => {
      if (!value || typeof value !== 'object') {
        return this.handleRenderError(new Error('invalid data provided to the expression renderer'));
      }
      if (value.type !== 'render' || !value.as) {
        if (value.type === 'error') {
          return this.handleRenderError(value.error);
        } else {
          return this.handleRenderError(new Error('invalid data provided to the expression renderer'));
        }
      }
      if (!(0, _services.getRenderersRegistry)().get(value.as)) {
        return this.handleRenderError(new Error(`invalid renderer id '${value.as}'`));
      }
      try {
        // Rendering is asynchronous, completed by handlers.done()
        await (0, _services.getRenderersRegistry)().get(value.as).render(this.element, value.value, {
          ...this.handlers,
          uiState
        });
      } catch (e) {
        return this.handleRenderError(e);
      }
    });
    (0, _defineProperty2.default)(this, "destroy", () => {
      this.renderSubject.complete();
      this.eventsSubject.complete();
      this.updateSubject.complete();
      if (this.destroyFn) {
        this.destroyFn();
      }
    });
    (0, _defineProperty2.default)(this, "getElement", () => {
      return this.element;
    });
    (0, _defineProperty2.default)(this, "handleRenderError", error => {
      this.onRenderError(this.element, error, this.handlers);
    });
    this.element = element;
    this.eventsSubject = new Rx.Subject();
    this.events$ = this.eventsSubject.asObservable();
    this.onRenderError = onRenderError || _render_error_handler.renderErrorHandler;
    this.renderSubject = new Rx.BehaviorSubject(null);
    this.render$ = this.renderSubject.asObservable().pipe((0, _operators.filter)(_lodash.isNumber));
    this.updateSubject = new Rx.Subject();
    this.update$ = this.updateSubject.asObservable();
    this.handlers = {
      onDestroy: fn => {
        this.destroyFn = fn;
      },
      done: () => {
        this.renderCount++;
        this.renderSubject.next(this.renderCount);
      },
      reload: () => {
        this.updateSubject.next(null);
      },
      getExecutionContext() {
        return executionContext;
      },
      update: params => {
        this.updateSubject.next(params);
      },
      event: data => {
        this.eventsSubject.next(data);
      },
      getRenderMode: () => {
        return renderMode || 'view';
      },
      isSyncColorsEnabled: () => {
        return syncColors || false;
      },
      isSyncTooltipsEnabled: () => {
        return syncTooltips || false;
      },
      isSyncCursorEnabled: () => {
        return syncCursor || true;
      },
      isInteractive: () => {
        return interactive !== null && interactive !== void 0 ? interactive : true;
      },
      hasCompatibleActions,
      getCompatibleCellValueActions
    };
  }
}
exports.ExpressionRenderHandler = ExpressionRenderHandler;
const render = async (element, data, options) => {
  const handler = new ExpressionRenderHandler(element, options);
  handler.render(data);
  return handler;
};
exports.render = render;