"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapeComponent = ShapeComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reusable = require("../reusable");
var _lib = require("../../../common/lib");
var _ = require("../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ShapeComponent({
  onLoaded,
  parentNode,
  shape: shapeType,
  fill,
  border,
  borderWidth,
  maintainAspect
}) {
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: parentNode.offsetWidth,
    height: parentNode.offsetHeight
  });
  const [shapeData, setShapeData] = (0, _react.useState)((0, _reusable.getDefaultShapeData)());
  (0, _react.useEffect)(() => {
    setDimensions({
      width: parentNode.offsetWidth,
      height: parentNode.offsetHeight
    });
    onLoaded();
  }, [parentNode, parentNodeDimensions, onLoaded]);
  const shapeRef = (0, _react.useCallback)(node => {
    if (node !== null) setShapeData(node.getData());
  }, []);
  const strokeWidth = Math.max(borderWidth, 0);
  const shapeContentAttributes = {
    strokeWidth: String(strokeWidth),
    vectorEffect: 'non-scaling-stroke',
    strokeMiterlimit: '999'
  };
  if (fill) shapeContentAttributes.fill = fill;
  if (border) shapeContentAttributes.stroke = border;
  const {
    width,
    height
  } = dimensions;
  const shapeAttributes = {
    width,
    height,
    overflow: 'visible',
    preserveAspectRatio: maintainAspect ? 'xMidYMid meet' : 'none',
    viewBox: (0, _lib.getViewBox)(shapeData.viewBox, {
      borderOffset: strokeWidth,
      width,
      height
    })
  };
  parentNode.style.lineHeight = '0';
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "shapeAligner"
  }, /*#__PURE__*/_react.default.createElement(_.ShapeDrawerComponent, {
    shapeType: shapeType,
    shapeContentAttributes: shapeContentAttributes,
    shapeAttributes: shapeAttributes,
    ref: shapeRef
  }));
}