"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricVisRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
// @ts-ignore
const MetricVisComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/metric_component'))));
async function metricFilterable(dimensions, table, handlers) {
  return Promise.all(dimensions.metrics.map(async metric => {
    var _handlers$hasCompatib;
    const column = (0, _utils.getColumnByAccessor)(metric, table.columns);
    const colIndex = table.columns.indexOf(column);
    return Boolean(await ((_handlers$hasCompatib = handlers.hasCompatibleActions) === null || _handlers$hasCompatib === void 0 ? void 0 : _handlers$hasCompatib.call(handlers, {
      name: 'filter',
      data: {
        data: [{
          table,
          column: colIndex,
          row: 0
        }]
      }
    })));
  }));
}

/** @internal **/

const getMetricVisRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_METRIC_NAME,
  displayName: 'metric visualization',
  reuseDomNode: true,
  render: async (domNode, {
    visData,
    visConfig,
    canNavigateToLens
  }, handlers) => {
    var _visData$rows;
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const filterable = await metricFilterable(visConfig.dimensions, visData, handlers);
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_legacy_metric`, canNavigateToLens ? `render_${visualizationType}_legacy_metric_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public2.VisualizationContainer, {
      "data-test-subj": "legacyMtrVis",
      className: "legacyMtrVis",
      showNoResult: !((_visData$rows = visData.rows) !== null && _visData$rows !== void 0 && _visData$rows.length),
      renderComplete: renderComplete,
      handlers: handlers
    }, /*#__PURE__*/_react.default.createElement(MetricVisComponent, {
      visData: visData,
      visParams: visConfig,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      filterable: filterable
    }))), domNode);
  }
});
exports.getMetricVisRenderer = getMetricVisRenderer;