"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricVisValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MetricVisValue = props => {
  const {
    style,
    metric,
    onFilter,
    labelConfig,
    colorFullBackground,
    autoScale
  } = props;
  const containerClassName = (0, _classnames.default)('legacyMtrVis__container', {
    'legacyMtrVis__container--light': metric.lightText,
    'legacyMtrVis__container-isfilterable': onFilter,
    'legacyMtrVis__container-isfull': !autoScale && colorFullBackground
  });
  (0, _react.useLayoutEffect)(() => {
    var _props$renderComplete;
    (_props$renderComplete = props.renderComplete) === null || _props$renderComplete === void 0 ? void 0 : _props$renderComplete.call(props);
  }, [props]);

  // for autoScale true we should add background to upper level so that correct colorize full container
  const metricComponent = /*#__PURE__*/_react.default.createElement("div", {
    className: containerClassName,
    style: autoScale && colorFullBackground ? {} : {
      backgroundColor: metric.bgColor
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "metric_value",
    className: "legacyMtrVis__value",
    style: {
      ...style.spec,
      ...(metric.color ? {
        color: metric.color
      } : {})
    }
    /*
     * Justification for dangerouslySetInnerHTML:
     * This is one of the visualizations which makes use of the HTML field formatters.
     * Since these formatters produce raw HTML, this visualization needs to be able to render them as-is, relying
     * on the field formatter to only produce safe HTML.
     * `metric.value` is set by the MetricVisComponent, so this component must make sure this value never contains
     * any unsafe HTML (e.g. by bypassing the field formatter).
     */,
    dangerouslySetInnerHTML: {
      __html: metric.value
    } // eslint-disable-line react/no-danger
  }), labelConfig.show && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "metric_label",
    style: {
      ...labelConfig.style.spec,
      order: labelConfig.position === 'top' ? -1 : 2
    }
  }, metric.label));
  if (onFilter) {
    return /*#__PURE__*/_react.default.createElement("button", {
      style: {
        display: 'block'
      },
      onClick: () => onFilter(),
      title: _i18n.i18n.translate('expressionLegacyMetricVis.filterTitle', {
        defaultMessage: 'Click to filter by field'
      })
    }, metricComponent);
  }
  return metricComponent;
};
exports.MetricVisValue = MetricVisValue;