"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeZone = getTimeZone;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Get timeZone from uiSettings
 */
function getTimeZone(uiSettings) {
  if (uiSettings.isDefault('dateFormat:tz')) {
    const detectedTimeZone = _moment.default.tz.guess();
    return detectedTimeZone || (0, _moment.default)().format('Z');
  } else {
    return uiSettings.get('dateFormat:tz', 'Browser');
  }
}