"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendColorPickerWrapperContext = exports.LegendColorPickerWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _public = require("@kbn/charts-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KEY_CODE_ENTER = 13;
function getAnchorPosition(legendPosition) {
  switch (legendPosition) {
    case _charts.Position.Bottom:
      return 'upCenter';
    case _charts.Position.Top:
      return 'downCenter';
    case _charts.Position.Left:
      return 'rightCenter';
    default:
      return 'leftCenter';
  }
}
const LegendColorPickerWrapperContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.LegendColorPickerWrapperContext = LegendColorPickerWrapperContext;
const LegendColorPickerWrapper = ({
  anchor,
  color,
  onClose,
  onChange,
  seriesIdentifiers: [seriesIdentifier]
}) => {
  var _uiState$get;
  const colorPickerWrappingContext = (0, _react.useContext)(LegendColorPickerWrapperContext);
  const handleOutsideClick = (0, _react.useCallback)(() => {
    onClose === null || onClose === void 0 ? void 0 : onClose();
  }, [onClose]);
  if (!colorPickerWrappingContext) {
    return null;
  }
  const {
    legendPosition,
    setColor,
    uiState
  } = colorPickerWrappingContext;
  const seriesName = seriesIdentifier.key;
  const overwriteColors = (_uiState$get = uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.colors', {})) !== null && _uiState$get !== void 0 ? _uiState$get : {};
  const colorIsOverwritten = (seriesName.toString() in overwriteColors);
  let keyDownEventOn = false;
  const handleChange = newColor => {
    if (newColor) {
      onChange(newColor);
    }
    setColor(newColor, seriesName);
    // close the popover if no color is applied or the user has clicked a color
    if (!newColor || !keyDownEventOn) {
      onClose();
    }
  };
  const onKeyDown = e => {
    if (e.keyCode === KEY_CODE_ENTER) {
      onClose === null || onClose === void 0 ? void 0 : onClose();
    }
    keyDownEventOn = true;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: handleOutsideClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: true,
    ownFocus: true,
    display: "block",
    button: anchor,
    anchorPosition: getAnchorPosition(legendPosition),
    closePopover: onClose,
    panelPaddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_public.ColorPicker, {
    color: color,
    onChange: handleChange,
    label: seriesName,
    useLegacyColors: false,
    colorIsOverwritten: colorIsOverwritten,
    onKeyDown: onKeyDown
  })));
};
exports.LegendColorPickerWrapper = LegendColorPickerWrapper;