"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.heatmapRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _analytics = require("@kbn/analytics");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../common");
var _services = require("../services");
var _get_timezone = require("../utils/get_timezone");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const heatmapRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_HEATMAP_NAME,
  displayName: _i18n.i18n.translate('expressionHeatmap.visualizationName', {
    defaultMessage: 'Heatmap'
  }),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const onClickValue = data => {
      handlers.event({
        name: 'filter',
        data
      });
    };
    const onSelectRange = data => {
      handlers.event({
        name: 'brush',
        data
      });
    };
    const onClickMultiValue = data => {
      handlers.event({
        name: 'multiFilter',
        data
      });
    };
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${_common.EXPRESSION_HEATMAP_NAME}`, config.canNavigateToLens ? `render_${visualizationType}_${_common.EXPRESSION_HEATMAP_NAME}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const timeZone = (0, _get_timezone.getTimeZone)((0, _services.getUISettings)());
    const {
      HeatmapComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/heatmap_component')));
    const {
      isInteractive
    } = handlers;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "heatmap-container",
      "data-test-subj": "heatmapChart"
    }, /*#__PURE__*/_react.default.createElement(HeatmapComponent, (0, _extends2.default)({}, config, {
      onClickValue: onClickValue,
      onSelectRange: onSelectRange,
      timeZone: timeZone,
      datatableUtilities: (0, _services.getDatatableUtilities)(),
      formatFactory: (0, _services.getFormatService)().deserialize,
      chartsThemeService: plugins.charts.theme,
      paletteService: (0, _services.getPaletteService)(),
      renderComplete: renderComplete,
      uiState: handlers.uiState,
      interactive: isInteractive(),
      chartsActiveCursorService: plugins.charts.activeCursor,
      syncTooltips: config.syncTooltips,
      syncCursor: config.syncCursor,
      onClickMultiValue: onClickMultiValue
    }))))), domNode);
  }
});
exports.heatmapRenderer = heatmapRenderer;