"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ErrorComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Error = (0, _public.withSuspense)(_.LazyErrorComponent);
function ErrorComponent({
  onLoaded,
  parentNode,
  error
}) {
  const getButtonSize = node => Math.min(node.clientHeight, node.clientWidth);
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [buttonSize, setButtonSize] = (0, _react.useState)(getButtonSize(parentNode));
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const handlePopoverClick = () => setPopoverOpen(!isPopoverOpen);
  const closePopover = () => setPopoverOpen(false);
  const updateErrorView = (0, _react.useCallback)(() => {
    setButtonSize(getButtonSize(parentNode));
    onLoaded();
  }, [parentNode, onLoaded]);
  (0, _react.useEffect)(() => {
    updateErrorView();
  }, [parentNodeDimensions, updateErrorView]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasRenderError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "canvasRenderError__icon",
      onClick: handlePopoverClick,
      style: {
        height: buttonSize,
        width: buttonSize
      },
      type: "warning"
    }),
    isOpen: isPopoverOpen
  }, /*#__PURE__*/_react.default.createElement(Error, {
    payload: {
      error
    },
    onClose: closePopover
  })));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;