"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterValues = useFilterValues;
var _esQuery = require("@kbn/es-query");
var _use_values_list = require("../../../../hooks/use_values_list");
var _use_app_data_view = require("../hooks/use_app_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFilterValues({
  field,
  series,
  baseFilters,
  label
}, query) {
  var _dataViews$series$dat;
  const {
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const queryFilters = [];
  baseFilters === null || baseFilters === void 0 ? void 0 : baseFilters.forEach(qFilter => {
    if (qFilter.query) {
      queryFilters.push(qFilter.query);
    }
    if ((0, _esQuery.isExistsFilter)(qFilter)) {
      queryFilters.push({
        exists: qFilter.query.exists
      });
    }
  });
  return (0, _use_values_list.useValuesList)({
    query,
    label: label !== null && label !== void 0 ? label : field,
    sourceField: field,
    time: series.time,
    keepHistory: true,
    filters: queryFilters,
    dataViewTitle: (_dataViews$series$dat = dataViews[series.dataType]) === null || _dataViews$series$dat === void 0 ? void 0 : _dataViews$series$dat.title
  });
}