"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedFilters = SelectedFilters;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter_label = require("../../components/filter_label");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _use_series_filters = require("../../hooks/use_series_filters");
var _use_series_storage = require("../../hooks/use_series_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SelectedFilters({
  seriesId,
  series,
  seriesConfig
}) {
  var _series$filters, _series$filters2;
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    labels
  } = seriesConfig;
  const filters = (_series$filters = series.filters) !== null && _series$filters !== void 0 ? _series$filters : [];
  const {
    removeFilter,
    replaceFilter
  } = (0, _use_series_filters.useSeriesFilters)({
    seriesId,
    series
  });
  const {
    dataView
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  if (filters.length === 0 || !dataView) {
    return null;
  }
  const btnProps = {
    seriesId,
    series,
    dataView
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs",
    alignItems: "center"
  }, filters.map(({
    field,
    values = [],
    notValues = [],
    wildcards = [],
    notWildcards = []
  }) => {
    var _labels$field, _labels$field2, _labels$field3, _labels$field4;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: field
    }, values.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        maxWidth: 300
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: (_labels$field = labels[field]) !== null && _labels$field !== void 0 ? _labels$field : field,
      value: values !== null && values !== void 0 ? values : [],
      removeFilter: () => {
        replaceFilter({
          field,
          values: [],
          notValues,
          wildcards,
          notWildcards
        });
      },
      negate: false
    }, btnProps))), notValues.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: false,
      style: {
        maxWidth: 300
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: (_labels$field2 = labels[field]) !== null && _labels$field2 !== void 0 ? _labels$field2 : field,
      value: notValues !== null && notValues !== void 0 ? notValues : [],
      negate: true,
      removeFilter: () => {
        replaceFilter({
          field,
          notValues: [],
          values,
          wildcards,
          notWildcards
        });
      }
    }, btnProps))), wildcards.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: false,
      style: {
        maxWidth: 300
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: _i18n.i18n.translate('xpack.exploratoryView.filters.label.wildcard', {
        defaultMessage: '{label} wildcard',
        values: {
          label: (_labels$field3 = labels[field]) !== null && _labels$field3 !== void 0 ? _labels$field3 : field
        }
      }),
      value: wildcards !== null && wildcards !== void 0 ? wildcards : [],
      negate: false,
      removeFilter: () => {
        wildcards === null || wildcards === void 0 ? void 0 : wildcards.forEach(val => {
          removeFilter({
            field,
            value: val,
            negate: false,
            isWildcard: true
          });
        });
      }
    }, btnProps))), notWildcards.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: false,
      style: {
        maxWidth: 300
      }
    }, /*#__PURE__*/_react.default.createElement(_filter_label.FilterLabel, (0, _extends2.default)({
      field: field,
      label: _i18n.i18n.translate('xpack.exploratoryView.filters.label.wildcard', {
        defaultMessage: '{label} wildcard',
        values: {
          label: (_labels$field4 = labels[field]) !== null && _labels$field4 !== void 0 ? _labels$field4 : field
        }
      }),
      value: notWildcards !== null && notWildcards !== void 0 ? notWildcards : [],
      negate: false,
      removeFilter: () => {
        notWildcards === null || notWildcards === void 0 ? void 0 : notWildcards.forEach(val => {
          removeFilter({
            field,
            value: val,
            negate: true,
            isWildcard: true
          });
        });
      }
    }, btnProps))));
  }), ((_series$filters2 = series.filters) !== null && _series$filters2 !== void 0 ? _series$filters2 : []).length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11ySelectedFiltersClearFiltersButton",
    flush: "left",
    iconType: "cross",
    onClick: () => {
      setSeries(seriesId, {
        ...series,
        filters: undefined
      });
    },
    size: "xs"
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.clearFilter', {
    defaultMessage: 'Clear filters'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}