"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDefinitionField = ReportDefinitionField;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _url_constants = require("../../configurations/constants/url_constants");
var _field_value_suggestions = _interopRequireDefault(require("../../../field_value_suggestions"));
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _utils = require("../../configurations/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ReportDefinitionField({
  singleSelection,
  keepHistory,
  series,
  field: fieldProp,
  seriesConfig,
  onChange,
  filters
}) {
  var _labels$field;
  const {
    dataView
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const field = typeof fieldProp === 'string' ? fieldProp : fieldProp.field;
  const {
    reportDefinitions: selectedReportDefinitions = {}
  } = series;
  const {
    labels,
    baseFilters,
    definitionFields
  } = seriesConfig;
  const queryFilters = (0, _react.useMemo)(() => {
    const filtersN = [];
    (baseFilters !== null && baseFilters !== void 0 ? baseFilters : []).concat(filters !== null && filters !== void 0 ? filters : []).forEach(qFilter => {
      if (qFilter.query) {
        filtersN.push(qFilter.query);
      }
      const existFilter = qFilter;
      if (existFilter.query.exists) {
        filtersN.push({
          exists: existFilter.query.exists
        });
      }
    });
    if (!(0, _lodash.isEmpty)(selectedReportDefinitions)) {
      definitionFields.forEach(fieldObj => {
        const fieldT = typeof fieldObj === 'string' ? fieldObj : fieldObj.field;
        if (dataView && selectedReportDefinitions !== null && selectedReportDefinitions !== void 0 && selectedReportDefinitions[fieldT] && fieldT !== field) {
          const values = selectedReportDefinitions === null || selectedReportDefinitions === void 0 ? void 0 : selectedReportDefinitions[fieldT];
          if (!values.includes(_url_constants.ALL_VALUES_SELECTED)) {
            const valueFilter = (0, _utils.buildPhrasesFilter)(fieldT, values, dataView)[0];
            if (valueFilter.query) {
              filtersN.push(valueFilter.query);
            }
          }
        }
      });
    }
    return filtersN;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(selectedReportDefinitions), JSON.stringify(baseFilters)]);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_field_value_suggestions.default, {
    label: (_labels$field = labels[field]) !== null && _labels$field !== void 0 ? _labels$field : field,
    sourceField: field,
    dataViewTitle: dataView.title,
    selectedValue: selectedReportDefinitions === null || selectedReportDefinitions === void 0 ? void 0 : selectedReportDefinitions[field],
    onChange: val => onChange(field, val),
    filters: queryFilters,
    time: series.time,
    fullWidth: true,
    asCombobox: true,
    allowExclusions: false,
    allowAllValuesSelection: true,
    usePrependLabel: false,
    compressed: false,
    required: (0, _lodash.isEmpty)(selectedReportDefinitions),
    singleSelection: singleSelection,
    keepHistory: keepHistory
  });
}