"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbedAction = EmbedAction;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_series_storage = require("../hooks/use_series_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbedAction({
  lensAttributes
}) {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    reportType,
    allSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yEmbedActionButton",
    size: "s",
    isDisabled: lensAttributes === null,
    onClick: () => {
      setIsOpen(!isOpen);
    }
  }, EMBED_LABEL);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: () => setIsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, EMBED_TITLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "jsx",
    fontSize: "m",
    paddingSize: "m",
    isCopyable: true,
    style: {
      width: 500
    }
  }, `const { observability } = useKibana<>().services;

const { ExploratoryViewEmbeddable } = observability;

<ExploratoryViewEmbeddable
        customHeight={'300px'}
        reportType="${reportType}"
        attributes={${JSON.stringify(allSeries, null, 2)}}
 />
        `));
}
const EMBED_TITLE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.heading.embedTitle', {
  defaultMessage: 'Embed Exploratory view (Dev only feature)'
});
const EMBED_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.heading.embed', {
  defaultMessage: 'Embed <></>'
});