"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploratoryViewContext = void 0;
exports.ExploratoryViewContextProvider = ExploratoryViewContextProvider;
exports.SELECT_REPORT_TYPE = void 0;
exports.useExploratoryView = useExploratoryView;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExploratoryViewContext = /*#__PURE__*/(0, _react.createContext)({});
exports.ExploratoryViewContext = ExploratoryViewContext;
function ExploratoryViewContextProvider({
  children,
  reportTypes,
  dataTypes,
  reportConfigMap,
  setHeaderActionMenu,
  asPanel = true,
  theme$
}) {
  const [isEditMode, setIsEditMode] = (0, _react.useState)(false);
  const value = {
    asPanel,
    reportTypes,
    dataTypes,
    reportConfigMap,
    setHeaderActionMenu,
    theme$,
    isEditMode,
    setIsEditMode
  };
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewContext.Provider, {
    value: value
  }, children);
}
function useExploratoryView() {
  const context = (0, _react.useContext)(ExploratoryViewContext);
  if (context === undefined) {
    throw new Error('useExploratoryView must be used within a ExploratoryViewContextProvider');
  }
  return context;
}
const SELECT_REPORT_TYPE = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.selectReportType', {
  defaultMessage: 'No report type selected'
});
exports.SELECT_REPORT_TYPE = SELECT_REPORT_TYPE;