"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsFieldFormats = exports.MS_TO_HUMANIZE_PRECISE = void 0;
var _synthetics = require("../constants/field_names/synthetics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MS_TO_HUMANIZE_PRECISE = {
  inputFormat: 'milliseconds',
  outputFormat: 'humanizePrecise',
  outputPrecision: 1,
  showSuffix: true,
  useShortSuffix: true
};
exports.MS_TO_HUMANIZE_PRECISE = MS_TO_HUMANIZE_PRECISE;
const syntheticsFieldFormats = [{
  field: 'monitor.duration.us',
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'humanizePrecise',
      outputPrecision: 1,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _synthetics.SYNTHETICS_STEP_DURATION,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'humanizePrecise',
      outputPrecision: 1,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _synthetics.SYNTHETICS_LCP,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'humanizePrecise',
      outputPrecision: 1,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _synthetics.SYNTHETICS_FCP,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'humanizePrecise',
      outputPrecision: 1,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _synthetics.SYNTHETICS_DOCUMENT_ONLOAD,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'humanizePrecise',
      outputPrecision: 1,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}, {
  field: _synthetics.SYNTHETICS_DCL,
  format: {
    id: 'duration',
    params: {
      inputFormat: 'microseconds',
      outputFormat: 'humanizePrecise',
      outputPrecision: 1,
      showSuffix: true,
      useShortSuffix: true
    }
  }
}];
exports.syntheticsFieldFormats = syntheticsFieldFormats;