"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationGroupSavedObjectFinder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EventAnnotationGroupSavedObjectFinder = ({
  contentClient,
  uiSettings,
  fixedPageSize = 10,
  checkHasAnnotationGroups,
  onChoose,
  onCreateNew
}) => {
  const [hasAnnotationGroups, setHasAnnotationGroups] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    checkHasAnnotationGroups().then(setHasAnnotationGroups);
  }, [checkHasAnnotationGroups]);
  return hasAnnotationGroups === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null))) : hasAnnotationGroups === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
        height: 100%;
      `,
    direction: "column",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.emptyPromptTitle",
      defaultMessage: "Start by adding an annotation layer"
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.emptyPromptDescription",
      defaultMessage: "There are currently no annotations available to select from the library. Create a new layer to add annotations."
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => onCreateNew(),
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.emptyCTA",
      defaultMessage: "Create annotation layer"
    }))
  }))) : /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    fixedPageSize: fixedPageSize,
    onChoose: (id, type, fullName, savedObject) => {
      onChoose({
        id,
        type,
        fullName,
        savedObject
      });
    },
    showFilter: false,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.notFoundLabel",
      defaultMessage: "No matching annotation groups found."
    }),
    savedObjectMetaData: savedObjectMetaData,
    services: {
      contentClient,
      uiSettings
    }
  });
};
exports.EventAnnotationGroupSavedObjectFinder = EventAnnotationGroupSavedObjectFinder;
const savedObjectMetaData = [{
  type: _eventAnnotationCommon.EVENT_ANNOTATION_GROUP_TYPE,
  getIconForSavedObject: () => 'annotation',
  name: _i18n.i18n.translate('eventAnnotation.eventAnnotationGroup.metadata.name', {
    defaultMessage: 'Annotations Groups'
  }),
  includeFields: ['*']
}];