"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormWizard = FormWizard;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _form_wizard_context = require("./form_wizard_context");
var _form_wizard_nav = require("./form_wizard_nav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function FormWizard({
  texts,
  defaultActiveStep,
  defaultValue,
  apiError,
  isEditing,
  isSaving,
  onSave,
  onChange,
  onStepChange,
  children,
  rightContentNav
}) {
  return /*#__PURE__*/_react.default.createElement(_form_wizard_context.FormWizardProvider, {
    defaultValue: defaultValue,
    isEditing: isEditing,
    onSave: onSave,
    onChange: onChange,
    onStepChange: onStepChange,
    defaultActiveStep: defaultActiveStep
  }, /*#__PURE__*/_react.default.createElement(_form_wizard_context.FormWizardConsumer, null, ({
    activeStepIndex,
    lastStep,
    steps,
    isCurrentStepValid,
    navigateToStep,
    activeStepId
  }) => {
    const stepsRequiredArray = Object.values(steps).map(step => Boolean(step.isRequired) && step.isComplete === false);
    const getIsStepDisabled = stepIndex => {
      // Disable all steps when the current step is invalid
      if (stepIndex !== activeStepIndex && isCurrentStepValid === false) {
        return true;
      }
      let isDisabled = false;
      if (stepIndex > activeStepIndex + 1) {
        /**
         * Rule explained:
         * - all the previous steps are always enabled (we can go back anytime)
         * - the next step is also always enabled (it acts as the "Next" button)
         * - for the rest, the step is disabled if any of the previous step (_greater_ than the current
         * active step), is marked as isRequired **AND** has not been completed.
         */
        isDisabled = stepsRequiredArray.reduce((acc, isRequired, i) => {
          if (acc === true || i <= activeStepIndex || i >= stepIndex) {
            return acc;
          }
          return Boolean(isRequired);
        }, false);
      }
      return isDisabled;
    };
    const euiSteps = Object.values(steps).map(({
      index,
      label
    }) => {
      return {
        title: label,
        status: activeStepIndex === index ? 'selected' : activeStepIndex > index ? 'complete' : 'incomplete',
        disabled: getIsStepDisabled(index),
        'data-test-subj': `formWizardStep-${index}`,
        onClick: () => navigateToStep(index)
      };
    });
    const getRightContentNav = () => {
      if (typeof rightContentNav === 'function') {
        return rightContentNav(activeStepId);
      }
      return rightContentNav;
    };
    const onBack = () => {
      const prevStep = activeStepIndex - 1;
      navigateToStep(prevStep);
    };
    const onNext = () => {
      const nextStep = activeStepIndex + 1;
      navigateToStep(nextStep);
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
      steps: euiSteps
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), apiError, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_form_wizard_nav.FormWizardNav, {
      activeStepIndex: activeStepIndex,
      lastStep: lastStep,
      isStepValid: isCurrentStepValid,
      isSaving: isSaving,
      onBack: onBack,
      onNext: onNext,
      texts: texts,
      getRightContent: getRightContentNav
    }));
  }));
}