"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMatchAllFilter = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @param filter
 * @returns `true` if a filter is an `MatchAllFilter`
 *
 * @public
 */
const isMatchAllFilter = filter => (0, _lodash.has)(filter, 'query.match_all');
exports.isMatchAllFilter = isMatchAllFilter;