"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.availableIndices = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const availableIndices = async (client, indices) => {
  const availableIndicesList = await client.asCurrentUser.indices.get({
    expand_wildcards: ['all'],
    features: ['aliases', 'settings'],
    filter_path: ['*.aliases', '*.settings.index.verified_before_close'],
    index: '*'
  });
  return indices.filter(index => {
    var _availableIndicesList, _availableIndicesList2, _availableIndicesList3, _availableIndicesList4;
    return Object.keys(availableIndicesList).includes(index) && !(((_availableIndicesList = availableIndicesList[index].settings) === null || _availableIndicesList === void 0 ? void 0 : (_availableIndicesList2 = _availableIndicesList.index) === null || _availableIndicesList2 === void 0 ? void 0 : _availableIndicesList2.verified_before_close) === true || ((_availableIndicesList3 = availableIndicesList[index].settings) === null || _availableIndicesList3 === void 0 ? void 0 : (_availableIndicesList4 = _availableIndicesList3.index) === null || _availableIndicesList4 === void 0 ? void 0 : _availableIndicesList4.verified_before_close) === 'true');
  });
};
exports.availableIndices = availableIndices;