"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _constants = require("@kbn/search-api-panels/constants");
var _constants2 = require("../common/constants");
var _doc_links = require("./applications/shared/doc_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class EnterpriseSearchPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "esConfig", void 0);
    (0, _defineProperty2.default)(this, "data", {});
    (0, _defineProperty2.default)(this, "hasInitialized", false);
    (0, _defineProperty2.default)(this, "isSidebarEnabled", true);
    this.config = initializerContext.config.get();
    this.esConfig = {
      elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
    };
  }
  async getInitialData(http) {
    try {
      this.esConfig = await http.get('/internal/enterprise_search/es_config');
    } catch {
      this.esConfig = {
        elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
      };
    }
    if (!this.config.host) return; // No API to call
    if (this.hasInitialized) return; // We've already made an initial call

    try {
      this.data = await http.get('/internal/enterprise_search/config_data');
      this.hasInitialized = true;
    } catch (e) {
      this.data.errorConnectingMessage = `${e.response.status} ${e.message}`;
    }
  }
  async getKibanaDeps(core, params, cloudSetup) {
    // Helper for using start dependencies on mount (instead of setup dependencies)
    // and for grouping Kibana-related args together (vs. plugin-specific args)
    const [coreStart, pluginsStart] = await core.getStartServices();
    const cloud = cloudSetup && pluginsStart.cloud ? {
      ...cloudSetup,
      ...pluginsStart.cloud
    } : undefined;
    const plugins = {
      ...pluginsStart,
      cloud
    };
    coreStart.chrome.getChromeStyle$().subscribe(style => this.isSidebarEnabled = style === 'classic');
    return {
      core: coreStart,
      isSidebarEnabled: this.isSidebarEnabled,
      params,
      plugins
    };
  }
  getPluginData() {
    // Small helper for grouping plugin data related args together
    return {
      config: this.config,
      data: this.data,
      esConfig: this.esConfig,
      isSidebarEnabled: this.isSidebarEnabled
    };
  }
  setup(core, plugins) {
    var _config$ui;
    const {
      config
    } = this;
    if (!((_config$ui = config.ui) !== null && _config$ui !== void 0 && _config$ui.enabled)) {
      return;
    }
    const {
      cloud
    } = plugins;
    core.application.register({
      appRoute: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchOverview
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_overview')));
        return renderApp(EnterpriseSearchOverview, kibanaDeps, pluginData);
      },
      title: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.LOGO,
      id: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchContent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_content')));
        return renderApp(EnterpriseSearchContent, kibanaDeps, pluginData);
      },
      title: _constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.ELASTICSEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.ELASTICSEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ELASTICSEARCH_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Elasticsearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/elasticsearch')));
        return renderApp(Elasticsearch, kibanaDeps, pluginData);
      },
      title: _constants2.ELASTICSEARCH_PLUGIN.NAME
    });
    core.application.register({
      appRoute: _constants2.VECTOR_SEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.VECTOR_SEARCH_PLUGIN.LOGO,
      id: _constants2.VECTOR_SEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.VECTOR_SEARCH_PLUGIN.NAME);
        this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchVectorSearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/vector_search')));
        return renderApp(EnterpriseSearchVectorSearch, kibanaDeps, pluginData);
      },
      title: _constants2.VECTOR_SEARCH_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.AI_SEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.AI_SEARCH_PLUGIN.LOGO,
      id: _constants2.AI_SEARCH_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.AI_SEARCH_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchAISearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/ai_search')));
        return renderApp(EnterpriseSearchAISearch, kibanaDeps, pluginData);
      },
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      title: _constants2.AI_SEARCH_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.APPLICATIONS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.APPLICATIONS_PLUGIN.LOGO,
      id: _constants2.APPLICATIONS_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Applications
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/applications')));
        return renderApp(Applications, kibanaDeps, pluginData);
      },
      navLinkStatus: _public.AppNavLinkStatus.default,
      searchable: true,
      title: _constants2.APPLICATIONS_PLUGIN.NAV_TITLE
    });
    core.application.register({
      appRoute: _constants2.ANALYTICS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.ANALYTICS_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.ANALYTICS_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Analytics
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/analytics')));
        return renderApp(Analytics, kibanaDeps, pluginData);
      },
      navLinkStatus: _public.AppNavLinkStatus.default,
      searchable: true,
      title: _constants2.ANALYTICS_PLUGIN.NAME
    });
    core.application.register({
      appRoute: _constants2.SEARCH_EXPERIENCES_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      id: _constants2.SEARCH_EXPERIENCES_PLUGIN.ID,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants2.SEARCH_EXPERIENCES_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          SearchExperiences
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/search_experiences')));
        return renderApp(SearchExperiences, kibanaDeps, pluginData);
      },
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      title: _constants2.SEARCH_EXPERIENCES_PLUGIN.NAME
    });
    if (config.canDeployEntSearch) {
      core.application.register({
        appRoute: _constants2.APP_SEARCH_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        id: _constants2.APP_SEARCH_PLUGIN.ID,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants2.APP_SEARCH_PLUGIN.NAME);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            AppSearch
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/app_search')));
          return renderApp(AppSearch, kibanaDeps, pluginData);
        },
        navLinkStatus: _public.AppNavLinkStatus.hidden,
        title: _constants2.APP_SEARCH_PLUGIN.NAME
      });
      core.application.register({
        appRoute: _constants2.WORKPLACE_SEARCH_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        euiIconType: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        id: _constants2.WORKPLACE_SEARCH_PLUGIN.ID,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants2.WORKPLACE_SEARCH_PLUGIN.NAME);

          // The Workplace Search Personal dashboard needs the chrome hidden. We hide it globally
          // here first to prevent a flash of chrome on the Personal dashboard and unhide it for admin routes.
          if (this.config.host) chrome.setIsVisible(false);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            WorkplaceSearch
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/workplace_search')));
          return renderApp(WorkplaceSearch, kibanaDeps, pluginData);
        },
        navLinkStatus: _public.AppNavLinkStatus.hidden,
        title: _constants2.WORKPLACE_SEARCH_PLUGIN.NAME
      });
    }
    if (plugins.home) {
      plugins.home.featureCatalogue.registerSolution({
        description: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.DESCRIPTION,
        icon: 'logoEnterpriseSearch',
        id: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
        order: 100,
        path: _constants2.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL,
        title: _constants2.SEARCH_PRODUCT_NAME
      });
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.ANALYTICS_PLUGIN.DESCRIPTION,
        icon: 'appAnalytics',
        id: _constants2.ANALYTICS_PLUGIN.ID,
        path: _constants2.ANALYTICS_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.ANALYTICS_PLUGIN.NAME
      });
      if (config.canDeployEntSearch) {
        plugins.home.featureCatalogue.register({
          category: 'data',
          description: _constants2.APP_SEARCH_PLUGIN.DESCRIPTION,
          icon: 'appSearchApp',
          id: _constants2.APP_SEARCH_PLUGIN.ID,
          path: _constants2.APP_SEARCH_PLUGIN.URL,
          showOnHomePage: false,
          title: _constants2.APP_SEARCH_PLUGIN.NAME
        });
        plugins.home.featureCatalogue.register({
          category: 'data',
          description: _constants2.WORKPLACE_SEARCH_PLUGIN.DESCRIPTION,
          icon: 'workplaceSearchApp',
          id: _constants2.WORKPLACE_SEARCH_PLUGIN.ID,
          path: _constants2.WORKPLACE_SEARCH_PLUGIN.URL,
          showOnHomePage: false,
          title: _constants2.WORKPLACE_SEARCH_PLUGIN.NAME
        });
      }
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.ELASTICSEARCH_PLUGIN.DESCRIPTION,
        icon: 'appElasticsearch',
        id: _constants2.ELASTICSEARCH_PLUGIN.ID,
        path: _constants2.ELASTICSEARCH_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.ELASTICSEARCH_PLUGIN.NAME
      });
      plugins.home.featureCatalogue.register({
        category: 'data',
        description: _constants2.SEARCH_EXPERIENCES_PLUGIN.DESCRIPTION,
        icon: 'logoEnterpriseSearch',
        id: _constants2.SEARCH_EXPERIENCES_PLUGIN.ID,
        path: _constants2.SEARCH_EXPERIENCES_PLUGIN.URL,
        showOnHomePage: false,
        title: _constants2.SEARCH_EXPERIENCES_PLUGIN.NAME
      });
    }
  }
  async start(core) {
    var _this$config$ui;
    if (!((_this$config$ui = this.config.ui) !== null && _this$config$ui !== void 0 && _this$config$ui.enabled)) {
      return;
    }
    // This must be called here in start() and not in `applications/index.tsx` to prevent loading
    // race conditions with our apps' `routes.ts` being initialized before `renderApp()`
    _doc_links.docLinks.setDocLinks(core.docLinks);
  }
  stop() {}
}
exports.EnterpriseSearchPlugin = EnterpriseSearchPlugin;