"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Security = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _licensing = require("../../../shared/licensing");
var _unsaved_changes_prompt = require("../../../shared/unsaved_changes_prompt");
var _layout = require("../../components/layout");
var _license_callout = require("../../components/shared/license_callout");
var _constants = require("../../constants");
var _private_sources_table = require("./components/private_sources_table");
var _security_logic = require("./security_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Security = () => {
  const [confirmModalVisible, setConfirmModalVisibility] = (0, _react.useState)(false);
  const hideConfirmModal = () => setConfirmModalVisibility(false);
  const showConfirmModal = () => setConfirmModalVisibility(true);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    initializeSourceRestrictions,
    updatePrivateSourcesEnabled,
    updateRemoteEnabled,
    updateRemoteSource,
    updateStandardEnabled,
    updateStandardSource,
    saveSourceRestrictions,
    resetState
  } = (0, _kea.useActions)(_security_logic.SecurityLogic);
  const {
    isEnabled,
    remote,
    standard,
    dataLoading,
    unsavedChanges
  } = (0, _kea.useValues)(_security_logic.SecurityLogic);
  (0, _react.useEffect)(() => {
    initializeSourceRestrictions();
  }, []);
  const savePrivateSources = () => {
    saveSourceRestrictions();
    hideConfirmModal();
  };
  const headerActions = [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !hasPlatinumLicense || !unsavedChanges || dataLoading,
    onClick: showConfirmModal,
    fill: true,
    "data-test-subj": "SaveSettingsButton"
  }, _constants.SAVE_SETTINGS_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !unsavedChanges || dataLoading,
    onClick: resetState
  }, _constants.RESET_BUTTON)];
  const allSourcesToggle = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    className: (0, _classnames.default)({
      'euiPanel--disabled': !hasPlatinumLicense
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: isEnabled,
    onChange: e => updatePrivateSourcesEnabled(e.target.checked),
    disabled: !hasPlatinumLicense,
    showLabel: false,
    label: "Private Sources Toggle",
    "data-test-subj": "PrivateSourcesToggle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _constants.PRIVATE_SOURCES_TOGGLE_DESCRIPTION)))));
  const platinumLicenseCallout = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_license_callout.LicenseCallout, {
    message: _constants.PRIVATE_PLATINUM_LICENSE_CALLOUT
  }));
  const sourceTables = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_private_sources_table.PrivateSourcesTable, {
    sourceType: "remote",
    sourceSection: remote,
    updateEnabled: updateRemoteEnabled,
    updateSource: updateRemoteSource
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_private_sources_table.PrivateSourcesTable, {
    sourceType: "standard",
    sourceSection: standard,
    updateEnabled: updateStandardEnabled,
    updateSource: updateStandardSource
  }));
  const confirmModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _constants.CONFIRM_CHANGES_TEXT,
    onConfirm: savePrivateSources,
    onCancel: hideConfirmModal,
    buttonColor: "primary",
    cancelButtonText: _constants.KEEP_EDITING_BUTTON,
    confirmButtonText: _constants.SAVE_CHANGES_BUTTON
  }, _constants.PRIVATE_SOURCES_UPDATE_CONFIRMATION_TEXT);
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.SECURITY],
    pageHeader: {
      pageTitle: _constants.PRIVATE_SOURCES,
      description: _constants.PRIVATE_SOURCES_DESCRIPTION,
      rightSideItems: headerActions
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: unsavedChanges,
    messageText: _constants.SECURITY_UNSAVED_CHANGES_MESSAGE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, allSourcesToggle, !hasPlatinumLicense && platinumLicenseCallout, sourceTables), confirmModalVisible && confirmModal);
};
exports.Security = Security;