"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.User = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _enterprise_search_url = require("../../../shared/enterprise_search_url");
var _role_mapping = require("../../../shared/role_mapping");
var _group_assignment_selector = require("./group_assignment_selector");
var _role_mappings_logic = require("./role_mappings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const roleTypes = ['admin', 'user'];
const User = () => {
  const {
    handleSaveUser,
    closeUsersAndRolesFlyout,
    setUserExistingRadioValue,
    setElasticsearchUsernameValue,
    setElasticsearchEmailValue,
    handleRoleChange,
    handleUsernameSelectChange
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    availableGroups,
    singleUserRoleMapping,
    userFormUserIsExisting,
    elasticsearchUsers,
    elasticsearchUser,
    roleType,
    roleMappingErrors,
    userCreated,
    userFormIsNewUser,
    smtpSettingsPresent,
    formLoading
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  const showGroupAssignmentSelector = availableGroups.length > 0;
  const hasAvailableUsers = elasticsearchUsers.length > 0;
  const flyoutDisabled = (!userFormUserIsExisting || !hasAvailableUsers) && !elasticsearchUser.username;
  const userIsDeactivated = !!(singleUserRoleMapping && !singleUserRoleMapping.invitation && !singleUserRoleMapping.elasticsearchUser.enabled);
  const userAddedInfo = singleUserRoleMapping && /*#__PURE__*/_react.default.createElement(_role_mapping.UserAddedInfo, {
    username: singleUserRoleMapping.elasticsearchUser.username,
    email: singleUserRoleMapping.elasticsearchUser.email,
    roleType: singleUserRoleMapping.roleMapping.roleType,
    showKibanaAccessWarning: !singleUserRoleMapping.hasEnterpriseSearchRole
  });
  const userInvitationCallout = (singleUserRoleMapping === null || singleUserRoleMapping === void 0 ? void 0 : singleUserRoleMapping.invitation) && /*#__PURE__*/_react.default.createElement(_role_mapping.UserInvitationCallout, {
    isNew: userCreated,
    invitationCode: singleUserRoleMapping.invitation.code,
    urlPrefix: (0, _enterprise_search_url.getWorkplaceSearchUrl)()
  });
  const createUserForm = /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: roleMappingErrors.length > 0,
    error: roleMappingErrors
  }, /*#__PURE__*/_react.default.createElement(_role_mapping.UserSelector, {
    isNewUser: userFormIsNewUser,
    smtpSettingsPresent: smtpSettingsPresent,
    elasticsearchUsers: elasticsearchUsers,
    handleRoleChange: handleRoleChange,
    elasticsearchUser: elasticsearchUser,
    setUserExisting: setUserExistingRadioValue,
    setElasticsearchEmailValue: setElasticsearchEmailValue,
    setElasticsearchUsernameValue: setElasticsearchUsernameValue,
    handleUsernameSelectChange: handleUsernameSelectChange,
    userFormUserIsExisting: userFormUserIsExisting,
    roleTypes: roleTypes,
    roleType: roleType
  }), showGroupAssignmentSelector && /*#__PURE__*/_react.default.createElement(_group_assignment_selector.GroupAssignmentSelector, null));
  return /*#__PURE__*/_react.default.createElement(_role_mapping.UserFlyout, {
    disabled: flyoutDisabled,
    formLoading: formLoading,
    isComplete: userCreated,
    isNew: userFormIsNewUser,
    closeUserFlyout: closeUsersAndRolesFlyout,
    handleSaveUser: handleSaveUser
  }, userCreated ? userAddedInfo : createUserForm, userInvitationCallout, userIsDeactivated && /*#__PURE__*/_react.default.createElement(_role_mapping.DeactivatedUserCallout, {
    isNew: userFormIsNewUser
  }));
};
exports.User = User;