"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRITE_SCOPE_DESCRIPTION = exports.SEARCH_SCOPE_DESCRIPTION = exports.SCOPES_LEAD_IN_MESSAGE = exports.HTTP_REDIRECT_WARNING_MESSAGE = exports.DENY_BUTTON_LABEL = exports.AUTHORIZE_BUTTON_LABEL = exports.AUTHORIZATION_REQUIRED_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HTTP_REDIRECT_WARNING_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.httpRedirectWarningMessage', {
  defaultMessage: 'This application is using an insecure redirect URI (http)'
});
exports.HTTP_REDIRECT_WARNING_MESSAGE = HTTP_REDIRECT_WARNING_MESSAGE;
const SCOPES_LEAD_IN_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.scopesLeadInMessage', {
  defaultMessage: 'This application will be able to'
});
exports.SCOPES_LEAD_IN_MESSAGE = SCOPES_LEAD_IN_MESSAGE;
const AUTHORIZATION_REQUIRED_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.authorizationTitle', {
  defaultMessage: 'Authorization required'
});
exports.AUTHORIZATION_REQUIRED_TITLE = AUTHORIZATION_REQUIRED_TITLE;
const AUTHORIZE_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.authorizeButtonLabel', {
  defaultMessage: 'Authorize'
});
exports.AUTHORIZE_BUTTON_LABEL = AUTHORIZE_BUTTON_LABEL;
const DENY_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.denyButtonLabel', {
  defaultMessage: 'Deny'
});
exports.DENY_BUTTON_LABEL = DENY_BUTTON_LABEL;
const SEARCH_SCOPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.searchScopeDescription', {
  defaultMessage: 'Search your data'
});
exports.SEARCH_SCOPE_DESCRIPTION = SEARCH_SCOPE_DESCRIPTION;
const WRITE_SCOPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.oauthAuthorize.writeScopeDescription', {
  defaultMessage: 'Modify your data'
});
exports.WRITE_SCOPE_DESCRIPTION = WRITE_SCOPE_DESCRIPTION;