"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _group_overview = require("./components/group_overview");
var _group_source_prioritization = require("./components/group_source_prioritization");
var _org_sources_modal = require("./components/org_sources_modal");
var _group_logic = require("./group_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupRouter = () => {
  const {
    groupId
  } = (0, _reactRouterDom.useParams)();
  const {
    initializeGroup,
    resetGroup
  } = (0, _kea.useActions)(_group_logic.GroupLogic);
  const {
    orgSourcesModalVisible
  } = (0, _kea.useValues)(_group_logic.GroupLogic);
  (0, _react.useEffect)(() => {
    initializeGroup(groupId);
    return resetGroup;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.GROUP_SOURCE_PRIORITIZATION_PATH
  }, /*#__PURE__*/_react.default.createElement(_group_source_prioritization.GroupSourcePrioritization, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.GROUP_PATH
  }, /*#__PURE__*/_react.default.createElement(_group_overview.GroupOverview, null))), orgSourcesModalVisible && /*#__PURE__*/_react.default.createElement(_org_sources_modal.OrgSourcesModal, null));
};
exports.GroupRouter = GroupRouter;