"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceIdentifier = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceIdentifier = ({
  id
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("strong", null, _constants2.ID_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  beforeMessage: _constants.COPY_TOOLTIP,
  afterMessage: _constants.COPIED_TOOLTIP,
  textToCopy: id
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": _constants.COPY_TOOLTIP,
  onClick: copy,
  iconType: "copy",
  color: "primary"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  value: id,
  readOnly: true,
  "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sourceIdentifier.sourceIdentifierFieldLabel', {
    defaultMessage: 'Source Identifier'
  })
}))));
exports.SourceIdentifier = SourceIdentifier;